// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.LtrBackupResponseInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of LtrBackupResponse.
 */
public interface LtrBackupResponse {
    /**
     * Gets the datasourceSizeInBytes property: Size of datasource in bytes.
     * 
     * @return the datasourceSizeInBytes value.
     */
    Long datasourceSizeInBytes();

    /**
     * Gets the dataTransferredInBytes property: Data transferred in bytes.
     * 
     * @return the dataTransferredInBytes value.
     */
    Long dataTransferredInBytes();

    /**
     * Gets the backupName property: Name of Backup operation.
     * 
     * @return the backupName value.
     */
    String backupName();

    /**
     * Gets the backupMetadata property: Metadata to be stored in RP. Store everything that will be required to perform
     * a successful restore using this Recovery point. e.g. Versions, DataFormat etc.
     * 
     * @return the backupMetadata value.
     */
    String backupMetadata();

    /**
     * Gets the status property: Service-set extensible enum indicating the status of operation.
     * 
     * @return the status value.
     */
    ExecutionStatus status();

    /**
     * Gets the startTime property: Start time of the operation.
     * 
     * @return the startTime value.
     */
    OffsetDateTime startTime();

    /**
     * Gets the endTime property: End time of the operation.
     * 
     * @return the endTime value.
     */
    OffsetDateTime endTime();

    /**
     * Gets the percentComplete property: PercentageCompleted.
     * 
     * @return the percentComplete value.
     */
    Double percentComplete();

    /**
     * Gets the errorCode property: The error code.
     * 
     * @return the errorCode value.
     */
    String errorCode();

    /**
     * Gets the errorMessage property: The error message.
     * 
     * @return the errorMessage value.
     */
    String errorMessage();

    /**
     * Gets the inner com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.LtrBackupResponseInner object.
     * 
     * @return the inner object.
     */
    LtrBackupResponseInner innerModel();
}
