// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request that is made for pre-backup.
 */
@Fluent
public final class LtrPreBackupRequest extends BackupRequestBase {
    /**
     * Creates an instance of LtrPreBackupRequest class.
     */
    public LtrPreBackupRequest() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LtrPreBackupRequest withBackupSettings(BackupSettings backupSettings) {
        super.withBackupSettings(backupSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (backupSettings() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property backupSettings in model LtrPreBackupRequest"));
        } else {
            backupSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LtrPreBackupRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backupSettings", backupSettings());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LtrPreBackupRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LtrPreBackupRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LtrPreBackupRequest.
     */
    public static LtrPreBackupRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LtrPreBackupRequest deserializedLtrPreBackupRequest = new LtrPreBackupRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backupSettings".equals(fieldName)) {
                    deserializedLtrPreBackupRequest.withBackupSettings(BackupSettings.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLtrPreBackupRequest;
        });
    }
}
