// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Maintenance window properties of a server.
 */
@Fluent
public final class MaintenanceWindow implements JsonSerializable<MaintenanceWindow> {
    /*
     * indicates whether custom window is enabled or disabled
     */
    private String customWindow;

    /*
     * start hour for maintenance window
     */
    private Integer startHour;

    /*
     * start minute for maintenance window
     */
    private Integer startMinute;

    /*
     * day of week for maintenance window
     */
    private Integer dayOfWeek;

    /**
     * Creates an instance of MaintenanceWindow class.
     */
    public MaintenanceWindow() {
    }

    /**
     * Get the customWindow property: indicates whether custom window is enabled or disabled.
     * 
     * @return the customWindow value.
     */
    public String customWindow() {
        return this.customWindow;
    }

    /**
     * Set the customWindow property: indicates whether custom window is enabled or disabled.
     * 
     * @param customWindow the customWindow value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withCustomWindow(String customWindow) {
        this.customWindow = customWindow;
        return this;
    }

    /**
     * Get the startHour property: start hour for maintenance window.
     * 
     * @return the startHour value.
     */
    public Integer startHour() {
        return this.startHour;
    }

    /**
     * Set the startHour property: start hour for maintenance window.
     * 
     * @param startHour the startHour value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withStartHour(Integer startHour) {
        this.startHour = startHour;
        return this;
    }

    /**
     * Get the startMinute property: start minute for maintenance window.
     * 
     * @return the startMinute value.
     */
    public Integer startMinute() {
        return this.startMinute;
    }

    /**
     * Set the startMinute property: start minute for maintenance window.
     * 
     * @param startMinute the startMinute value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withStartMinute(Integer startMinute) {
        this.startMinute = startMinute;
        return this;
    }

    /**
     * Get the dayOfWeek property: day of week for maintenance window.
     * 
     * @return the dayOfWeek value.
     */
    public Integer dayOfWeek() {
        return this.dayOfWeek;
    }

    /**
     * Set the dayOfWeek property: day of week for maintenance window.
     * 
     * @param dayOfWeek the dayOfWeek value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customWindow", this.customWindow);
        jsonWriter.writeNumberField("startHour", this.startHour);
        jsonWriter.writeNumberField("startMinute", this.startMinute);
        jsonWriter.writeNumberField("dayOfWeek", this.dayOfWeek);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaintenanceWindow from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaintenanceWindow if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MaintenanceWindow.
     */
    public static MaintenanceWindow fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaintenanceWindow deserializedMaintenanceWindow = new MaintenanceWindow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customWindow".equals(fieldName)) {
                    deserializedMaintenanceWindow.customWindow = reader.getString();
                } else if ("startHour".equals(fieldName)) {
                    deserializedMaintenanceWindow.startHour = reader.getNullable(JsonReader::getInt);
                } else if ("startMinute".equals(fieldName)) {
                    deserializedMaintenanceWindow.startMinute = reader.getNullable(JsonReader::getInt);
                } else if ("dayOfWeek".equals(fieldName)) {
                    deserializedMaintenanceWindow.dayOfWeek = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaintenanceWindow;
        });
    }
}
