// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Migration db state of an individual database.
 */
public final class MigrationDbState extends ExpandableStringEnum<MigrationDbState> {
    /**
     * Static value InProgress for MigrationDbState.
     */
    public static final MigrationDbState IN_PROGRESS = fromString("InProgress");

    /**
     * Static value WaitingForCutoverTrigger for MigrationDbState.
     */
    public static final MigrationDbState WAITING_FOR_CUTOVER_TRIGGER = fromString("WaitingForCutoverTrigger");

    /**
     * Static value Failed for MigrationDbState.
     */
    public static final MigrationDbState FAILED = fromString("Failed");

    /**
     * Static value Canceled for MigrationDbState.
     */
    public static final MigrationDbState CANCELED = fromString("Canceled");

    /**
     * Static value Succeeded for MigrationDbState.
     */
    public static final MigrationDbState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceling for MigrationDbState.
     */
    public static final MigrationDbState CANCELING = fromString("Canceling");

    /**
     * Creates a new instance of MigrationDbState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MigrationDbState() {
    }

    /**
     * Creates or finds a MigrationDbState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MigrationDbState.
     */
    public static MigrationDbState fromString(String name) {
        return fromString(name, MigrationDbState.class);
    }

    /**
     * Gets known MigrationDbState values.
     * 
     * @return known MigrationDbState values.
     */
    public static Collection<MigrationDbState> values() {
        return values(MigrationDbState.class);
    }
}
