// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Supported types of migration request include Validate, Migrate and ValidateAndMigrate.
 */
public final class MigrationOption extends ExpandableStringEnum<MigrationOption> {
    /**
     * Static value Validate for MigrationOption.
     */
    public static final MigrationOption VALIDATE = fromString("Validate");

    /**
     * Static value Migrate for MigrationOption.
     */
    public static final MigrationOption MIGRATE = fromString("Migrate");

    /**
     * Static value ValidateAndMigrate for MigrationOption.
     */
    public static final MigrationOption VALIDATE_AND_MIGRATE = fromString("ValidateAndMigrate");

    /**
     * Creates a new instance of MigrationOption value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MigrationOption() {
    }

    /**
     * Creates or finds a MigrationOption from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MigrationOption.
     */
    public static MigrationOption fromString(String name) {
        return fromString(name, MigrationOption.class);
    }

    /**
     * Gets known MigrationOption values.
     * 
     * @return known MigrationOption values.
     */
    public static Collection<MigrationOption> values() {
        return values(MigrationOption.class);
    }
}
