// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * An immutable client-side representation of MigrationResource.
 */
public interface MigrationResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the migrationId property: ID for migration, a GUID.
     * 
     * @return the migrationId value.
     */
    String migrationId();

    /**
     * Gets the currentStatus property: Current status of migration.
     * 
     * @return the currentStatus value.
     */
    MigrationStatus currentStatus();

    /**
     * Gets the migrationInstanceResourceId property: ResourceId of the private endpoint migration instance.
     * 
     * @return the migrationInstanceResourceId value.
     */
    String migrationInstanceResourceId();

    /**
     * Gets the migrationMode property: There are two types of migration modes Online and Offline.
     * 
     * @return the migrationMode value.
     */
    MigrationMode migrationMode();

    /**
     * Gets the migrationOption property: This indicates the supported Migration option for the migration.
     * 
     * @return the migrationOption value.
     */
    MigrationOption migrationOption();

    /**
     * Gets the sourceType property: migration source server type : OnPremises, AWS, GCP, AzureVM,
     * PostgreSQLSingleServer, AWS_RDS, AWS_AURORA, AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB.
     * 
     * @return the sourceType value.
     */
    SourceType sourceType();

    /**
     * Gets the sslMode property: SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is VerifyFull and
     * Prefer for other source types.
     * 
     * @return the sslMode value.
     */
    SslMode sslMode();

    /**
     * Gets the sourceDbServerMetadata property: Metadata of the source database server.
     * 
     * @return the sourceDbServerMetadata value.
     */
    DbServerMetadata sourceDbServerMetadata();

    /**
     * Gets the targetDbServerMetadata property: Metadata of the target database server.
     * 
     * @return the targetDbServerMetadata value.
     */
    DbServerMetadata targetDbServerMetadata();

    /**
     * Gets the sourceDbServerResourceId property: ResourceId of the source database server in case the sourceType is
     * PostgreSQLSingleServer. For other source types this should be ipaddress:port&#064;username or
     * hostname:port&#064;username.
     * 
     * @return the sourceDbServerResourceId value.
     */
    String sourceDbServerResourceId();

    /**
     * Gets the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @return the sourceDbServerFullyQualifiedDomainName value.
     */
    String sourceDbServerFullyQualifiedDomainName();

    /**
     * Gets the targetDbServerResourceId property: ResourceId of the source database server.
     * 
     * @return the targetDbServerResourceId value.
     */
    String targetDbServerResourceId();

    /**
     * Gets the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @return the targetDbServerFullyQualifiedDomainName value.
     */
    String targetDbServerFullyQualifiedDomainName();

    /**
     * Gets the secretParameters property: Migration secret parameters.
     * 
     * @return the secretParameters value.
     */
    MigrationSecretParameters secretParameters();

    /**
     * Gets the dbsToMigrate property: Number of databases to migrate.
     * 
     * @return the dbsToMigrate value.
     */
    List<String> dbsToMigrate();

    /**
     * Gets the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
     * LogicalReplicationOnSourceDb, if needed.
     * 
     * @return the setupLogicalReplicationOnSourceDbIfNeeded value.
     */
    LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded();

    /**
     * Gets the overwriteDbsInTarget property: Indicates whether the databases on the target server can be overwritten,
     * if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the
     * database already exists.
     * 
     * @return the overwriteDbsInTarget value.
     */
    OverwriteDbsInTargetEnum overwriteDbsInTarget();

    /**
     * Gets the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
     * 
     * @return the migrationWindowStartTimeInUtc value.
     */
    OffsetDateTime migrationWindowStartTimeInUtc();

    /**
     * Gets the migrationWindowEndTimeInUtc property: End time in UTC for migration window.
     * 
     * @return the migrationWindowEndTimeInUtc value.
     */
    OffsetDateTime migrationWindowEndTimeInUtc();

    /**
     * Gets the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
     * 
     * @return the migrateRoles value.
     */
    MigrateRolesEnum migrateRoles();

    /**
     * Gets the startDataMigration property: Indicates whether the data migration should start right away.
     * 
     * @return the startDataMigration value.
     */
    StartDataMigrationEnum startDataMigration();

    /**
     * Gets the triggerCutover property: To trigger cutover for entire migration we need to send this flag as True.
     * 
     * @return the triggerCutover value.
     */
    TriggerCutoverEnum triggerCutover();

    /**
     * Gets the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases send
     * triggerCutover flag as True and database names in this array.
     * 
     * @return the dbsToTriggerCutoverOn value.
     */
    List<String> dbsToTriggerCutoverOn();

    /**
     * Gets the cancel property: To trigger cancel for entire migration we need to send this flag as True.
     * 
     * @return the cancel value.
     */
    CancelEnum cancel();

    /**
     * Gets the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases send cancel flag
     * as True and database names in this array.
     * 
     * @return the dbsToCancelMigrationOn value.
     */
    List<String> dbsToCancelMigrationOn();

    /**
     * Gets the region of the resource.
     * 
     * @return the region of the resource.
     */
    Region region();

    /**
     * Gets the name of the resource region.
     * 
     * @return the name of the resource region.
     */
    String regionName();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner object.
     * 
     * @return the inner object.
     */
    MigrationResourceInner innerModel();

    /**
     * The entirety of the MigrationResource definition.
     */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithLocation,
        DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The MigrationResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the MigrationResource definition.
         */
        interface Blank extends WithLocation {
        }

        /**
         * The stage of the MigrationResource definition allowing to specify location.
         */
        interface WithLocation {
            /**
             * Specifies the region for the resource.
             * 
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithParentResource withRegion(Region location);

            /**
             * Specifies the region for the resource.
             * 
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithParentResource withRegion(String location);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies subscriptionId, resourceGroupName, targetDbServerName.
             * 
             * @param subscriptionId The subscription ID of the target database server.
             * @param resourceGroupName The resource group name of the target database server.
             * @param targetDbServerName The name of the target database server.
             * @return the next definition stage.
             */
            WithCreate withExistingFlexibleServer(String subscriptionId, String resourceGroupName,
                String targetDbServerName);
        }

        /**
         * The stage of the MigrationResource definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithTags, DefinitionStages.WithMigrationInstanceResourceId,
            DefinitionStages.WithMigrationMode, DefinitionStages.WithMigrationOption, DefinitionStages.WithSourceType,
            DefinitionStages.WithSslMode, DefinitionStages.WithSourceDbServerResourceId,
            DefinitionStages.WithSourceDbServerFullyQualifiedDomainName,
            DefinitionStages.WithTargetDbServerFullyQualifiedDomainName, DefinitionStages.WithSecretParameters,
            DefinitionStages.WithDbsToMigrate, DefinitionStages.WithSetupLogicalReplicationOnSourceDbIfNeeded,
            DefinitionStages.WithOverwriteDbsInTarget, DefinitionStages.WithMigrationWindowStartTimeInUtc,
            DefinitionStages.WithMigrationWindowEndTimeInUtc, DefinitionStages.WithMigrateRoles,
            DefinitionStages.WithStartDataMigration, DefinitionStages.WithTriggerCutover,
            DefinitionStages.WithDbsToTriggerCutoverOn, DefinitionStages.WithCancel,
            DefinitionStages.WithDbsToCancelMigrationOn {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            MigrationResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            MigrationResource create(Context context);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             * 
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            WithCreate withTags(Map<String, String> tags);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify migrationInstanceResourceId.
         */
        interface WithMigrationInstanceResourceId {
            /**
             * Specifies the migrationInstanceResourceId property: ResourceId of the private endpoint migration
             * instance.
             * 
             * @param migrationInstanceResourceId ResourceId of the private endpoint migration instance.
             * @return the next definition stage.
             */
            WithCreate withMigrationInstanceResourceId(String migrationInstanceResourceId);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify migrationMode.
         */
        interface WithMigrationMode {
            /**
             * Specifies the migrationMode property: There are two types of migration modes Online and Offline.
             * 
             * @param migrationMode There are two types of migration modes Online and Offline.
             * @return the next definition stage.
             */
            WithCreate withMigrationMode(MigrationMode migrationMode);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify migrationOption.
         */
        interface WithMigrationOption {
            /**
             * Specifies the migrationOption property: This indicates the supported Migration option for the migration.
             * 
             * @param migrationOption This indicates the supported Migration option for the migration.
             * @return the next definition stage.
             */
            WithCreate withMigrationOption(MigrationOption migrationOption);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify sourceType.
         */
        interface WithSourceType {
            /**
             * Specifies the sourceType property: migration source server type : OnPremises, AWS, GCP, AzureVM,
             * PostgreSQLSingleServer, AWS_RDS, AWS_AURORA, AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB.
             * 
             * @param sourceType migration source server type : OnPremises, AWS, GCP, AzureVM, PostgreSQLSingleServer,
             * AWS_RDS, AWS_AURORA, AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB.
             * @return the next definition stage.
             */
            WithCreate withSourceType(SourceType sourceType);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify sslMode.
         */
        interface WithSslMode {
            /**
             * Specifies the sslMode property: SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is
             * VerifyFull and Prefer for other source types.
             * 
             * @param sslMode SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is VerifyFull and
             * Prefer for other source types.
             * @return the next definition stage.
             */
            WithCreate withSslMode(SslMode sslMode);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify sourceDbServerResourceId.
         */
        interface WithSourceDbServerResourceId {
            /**
             * Specifies the sourceDbServerResourceId property: ResourceId of the source database server in case the
             * sourceType is PostgreSQLSingleServer. For other source types this should be ipaddress:port&#064;username
             * or hostname:port&#064;username.
             * 
             * @param sourceDbServerResourceId ResourceId of the source database server in case the sourceType is
             * PostgreSQLSingleServer. For other source types this should be ipaddress:port&#064;username or
             * hostname:port&#064;username.
             * @return the next definition stage.
             */
            WithCreate withSourceDbServerResourceId(String sourceDbServerResourceId);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify sourceDbServerFullyQualifiedDomainName.
         */
        interface WithSourceDbServerFullyQualifiedDomainName {
            /**
             * Specifies the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name
             * (FQDN) or IP address. It is a optional value, if customer provide it, migration service will always use
             * it for connection.
             * 
             * @param sourceDbServerFullyQualifiedDomainName Source server fully qualified domain name (FQDN) or IP
             * address. It is a optional value, if customer provide it, migration service will always use it for
             * connection.
             * @return the next definition stage.
             */
            WithCreate withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify targetDbServerFullyQualifiedDomainName.
         */
        interface WithTargetDbServerFullyQualifiedDomainName {
            /**
             * Specifies the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name
             * (FQDN) or IP address. It is a optional value, if customer provide it, migration service will always use
             * it for connection.
             * 
             * @param targetDbServerFullyQualifiedDomainName Target server fully qualified domain name (FQDN) or IP
             * address. It is a optional value, if customer provide it, migration service will always use it for
             * connection.
             * @return the next definition stage.
             */
            WithCreate withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify secretParameters.
         */
        interface WithSecretParameters {
            /**
             * Specifies the secretParameters property: Migration secret parameters.
             * 
             * @param secretParameters Migration secret parameters.
             * @return the next definition stage.
             */
            WithCreate withSecretParameters(MigrationSecretParameters secretParameters);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify dbsToMigrate.
         */
        interface WithDbsToMigrate {
            /**
             * Specifies the dbsToMigrate property: Number of databases to migrate.
             * 
             * @param dbsToMigrate Number of databases to migrate.
             * @return the next definition stage.
             */
            WithCreate withDbsToMigrate(List<String> dbsToMigrate);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify setupLogicalReplicationOnSourceDbIfNeeded.
         */
        interface WithSetupLogicalReplicationOnSourceDbIfNeeded {
            /**
             * Specifies the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
             * LogicalReplicationOnSourceDb, if needed.
             * 
             * @param setupLogicalReplicationOnSourceDbIfNeeded Indicates whether to setup LogicalReplicationOnSourceDb,
             * if needed.
             * @return the next definition stage.
             */
            WithCreate withSetupLogicalReplicationOnSourceDbIfNeeded(
                LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify overwriteDbsInTarget.
         */
        interface WithOverwriteDbsInTarget {
            /**
             * Specifies the overwriteDbsInTarget property: Indicates whether the databases on the target server can be
             * overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if
             * it detects that the database already exists..
             * 
             * @param overwriteDbsInTarget Indicates whether the databases on the target server can be overwritten, if
             * already present. If set to False, the migration workflow will wait for a confirmation, if it detects that
             * the database already exists.
             * @return the next definition stage.
             */
            WithCreate withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify migrationWindowStartTimeInUtc.
         */
        interface WithMigrationWindowStartTimeInUtc {
            /**
             * Specifies the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
             * 
             * @param migrationWindowStartTimeInUtc Start time in UTC for migration window.
             * @return the next definition stage.
             */
            WithCreate withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify migrationWindowEndTimeInUtc.
         */
        interface WithMigrationWindowEndTimeInUtc {
            /**
             * Specifies the migrationWindowEndTimeInUtc property: End time in UTC for migration window.
             * 
             * @param migrationWindowEndTimeInUtc End time in UTC for migration window.
             * @return the next definition stage.
             */
            WithCreate withMigrationWindowEndTimeInUtc(OffsetDateTime migrationWindowEndTimeInUtc);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify migrateRoles.
         */
        interface WithMigrateRoles {
            /**
             * Specifies the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
             * 
             * @param migrateRoles To migrate roles and permissions we need to send this flag as True.
             * @return the next definition stage.
             */
            WithCreate withMigrateRoles(MigrateRolesEnum migrateRoles);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify startDataMigration.
         */
        interface WithStartDataMigration {
            /**
             * Specifies the startDataMigration property: Indicates whether the data migration should start right away.
             * 
             * @param startDataMigration Indicates whether the data migration should start right away.
             * @return the next definition stage.
             */
            WithCreate withStartDataMigration(StartDataMigrationEnum startDataMigration);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify triggerCutover.
         */
        interface WithTriggerCutover {
            /**
             * Specifies the triggerCutover property: To trigger cutover for entire migration we need to send this flag
             * as True.
             * 
             * @param triggerCutover To trigger cutover for entire migration we need to send this flag as True.
             * @return the next definition stage.
             */
            WithCreate withTriggerCutover(TriggerCutoverEnum triggerCutover);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify dbsToTriggerCutoverOn.
         */
        interface WithDbsToTriggerCutoverOn {
            /**
             * Specifies the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases
             * send triggerCutover flag as True and database names in this array.
             * 
             * @param dbsToTriggerCutoverOn When you want to trigger cutover for specific databases send triggerCutover
             * flag as True and database names in this array.
             * @return the next definition stage.
             */
            WithCreate withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify cancel.
         */
        interface WithCancel {
            /**
             * Specifies the cancel property: To trigger cancel for entire migration we need to send this flag as True.
             * 
             * @param cancel To trigger cancel for entire migration we need to send this flag as True.
             * @return the next definition stage.
             */
            WithCreate withCancel(CancelEnum cancel);
        }

        /**
         * The stage of the MigrationResource definition allowing to specify dbsToCancelMigrationOn.
         */
        interface WithDbsToCancelMigrationOn {
            /**
             * Specifies the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases
             * send cancel flag as True and database names in this array.
             * 
             * @param dbsToCancelMigrationOn When you want to trigger cancel for specific databases send cancel flag as
             * True and database names in this array.
             * @return the next definition stage.
             */
            WithCreate withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn);
        }
    }

    /**
     * Begins update for the MigrationResource resource.
     * 
     * @return the stage of resource update.
     */
    MigrationResource.Update update();

    /**
     * The template for MigrationResource update.
     */
    interface Update extends UpdateStages.WithTags, UpdateStages.WithSourceDbServerResourceId,
        UpdateStages.WithSourceDbServerFullyQualifiedDomainName,
        UpdateStages.WithTargetDbServerFullyQualifiedDomainName, UpdateStages.WithSecretParameters,
        UpdateStages.WithDbsToMigrate, UpdateStages.WithSetupLogicalReplicationOnSourceDbIfNeeded,
        UpdateStages.WithOverwriteDbsInTarget, UpdateStages.WithMigrationWindowStartTimeInUtc,
        UpdateStages.WithMigrateRoles, UpdateStages.WithStartDataMigration, UpdateStages.WithTriggerCutover,
        UpdateStages.WithDbsToTriggerCutoverOn, UpdateStages.WithCancel, UpdateStages.WithDbsToCancelMigrationOn,
        UpdateStages.WithMigrationMode {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        MigrationResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        MigrationResource apply(Context context);
    }

    /**
     * The MigrationResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the MigrationResource update allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Application-specific metadata in the form of key-value pairs..
             * 
             * @param tags Application-specific metadata in the form of key-value pairs.
             * @return the next definition stage.
             */
            Update withTags(Map<String, String> tags);
        }

        /**
         * The stage of the MigrationResource update allowing to specify sourceDbServerResourceId.
         */
        interface WithSourceDbServerResourceId {
            /**
             * Specifies the sourceDbServerResourceId property: ResourceId of the source database server.
             * 
             * @param sourceDbServerResourceId ResourceId of the source database server.
             * @return the next definition stage.
             */
            Update withSourceDbServerResourceId(String sourceDbServerResourceId);
        }

        /**
         * The stage of the MigrationResource update allowing to specify sourceDbServerFullyQualifiedDomainName.
         */
        interface WithSourceDbServerFullyQualifiedDomainName {
            /**
             * Specifies the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name
             * (FQDN) or IP address. It is a optional value, if customer provide it, migration service will always use
             * it for connection.
             * 
             * @param sourceDbServerFullyQualifiedDomainName Source server fully qualified domain name (FQDN) or IP
             * address. It is a optional value, if customer provide it, migration service will always use it for
             * connection.
             * @return the next definition stage.
             */
            Update withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName);
        }

        /**
         * The stage of the MigrationResource update allowing to specify targetDbServerFullyQualifiedDomainName.
         */
        interface WithTargetDbServerFullyQualifiedDomainName {
            /**
             * Specifies the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name
             * (FQDN) or IP address. It is a optional value, if customer provide it, migration service will always use
             * it for connection.
             * 
             * @param targetDbServerFullyQualifiedDomainName Target server fully qualified domain name (FQDN) or IP
             * address. It is a optional value, if customer provide it, migration service will always use it for
             * connection.
             * @return the next definition stage.
             */
            Update withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName);
        }

        /**
         * The stage of the MigrationResource update allowing to specify secretParameters.
         */
        interface WithSecretParameters {
            /**
             * Specifies the secretParameters property: Migration secret parameters.
             * 
             * @param secretParameters Migration secret parameters.
             * @return the next definition stage.
             */
            Update withSecretParameters(MigrationSecretParameters secretParameters);
        }

        /**
         * The stage of the MigrationResource update allowing to specify dbsToMigrate.
         */
        interface WithDbsToMigrate {
            /**
             * Specifies the dbsToMigrate property: Number of databases to migrate.
             * 
             * @param dbsToMigrate Number of databases to migrate.
             * @return the next definition stage.
             */
            Update withDbsToMigrate(List<String> dbsToMigrate);
        }

        /**
         * The stage of the MigrationResource update allowing to specify setupLogicalReplicationOnSourceDbIfNeeded.
         */
        interface WithSetupLogicalReplicationOnSourceDbIfNeeded {
            /**
             * Specifies the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
             * LogicalReplicationOnSourceDb, if needed.
             * 
             * @param setupLogicalReplicationOnSourceDbIfNeeded Indicates whether to setup LogicalReplicationOnSourceDb,
             * if needed.
             * @return the next definition stage.
             */
            Update withSetupLogicalReplicationOnSourceDbIfNeeded(
                LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded);
        }

        /**
         * The stage of the MigrationResource update allowing to specify overwriteDbsInTarget.
         */
        interface WithOverwriteDbsInTarget {
            /**
             * Specifies the overwriteDbsInTarget property: Indicates whether the databases on the target server can be
             * overwritten, if already present. If set to False, the migration workflow will wait for a confirmation, if
             * it detects that the database already exists..
             * 
             * @param overwriteDbsInTarget Indicates whether the databases on the target server can be overwritten, if
             * already present. If set to False, the migration workflow will wait for a confirmation, if it detects that
             * the database already exists.
             * @return the next definition stage.
             */
            Update withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget);
        }

        /**
         * The stage of the MigrationResource update allowing to specify migrationWindowStartTimeInUtc.
         */
        interface WithMigrationWindowStartTimeInUtc {
            /**
             * Specifies the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
             * 
             * @param migrationWindowStartTimeInUtc Start time in UTC for migration window.
             * @return the next definition stage.
             */
            Update withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc);
        }

        /**
         * The stage of the MigrationResource update allowing to specify migrateRoles.
         */
        interface WithMigrateRoles {
            /**
             * Specifies the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
             * 
             * @param migrateRoles To migrate roles and permissions we need to send this flag as True.
             * @return the next definition stage.
             */
            Update withMigrateRoles(MigrateRolesEnum migrateRoles);
        }

        /**
         * The stage of the MigrationResource update allowing to specify startDataMigration.
         */
        interface WithStartDataMigration {
            /**
             * Specifies the startDataMigration property: Indicates whether the data migration should start right away.
             * 
             * @param startDataMigration Indicates whether the data migration should start right away.
             * @return the next definition stage.
             */
            Update withStartDataMigration(StartDataMigrationEnum startDataMigration);
        }

        /**
         * The stage of the MigrationResource update allowing to specify triggerCutover.
         */
        interface WithTriggerCutover {
            /**
             * Specifies the triggerCutover property: To trigger cutover for entire migration we need to send this flag
             * as True.
             * 
             * @param triggerCutover To trigger cutover for entire migration we need to send this flag as True.
             * @return the next definition stage.
             */
            Update withTriggerCutover(TriggerCutoverEnum triggerCutover);
        }

        /**
         * The stage of the MigrationResource update allowing to specify dbsToTriggerCutoverOn.
         */
        interface WithDbsToTriggerCutoverOn {
            /**
             * Specifies the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases
             * send triggerCutover flag as True and database names in this array.
             * 
             * @param dbsToTriggerCutoverOn When you want to trigger cutover for specific databases send triggerCutover
             * flag as True and database names in this array.
             * @return the next definition stage.
             */
            Update withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn);
        }

        /**
         * The stage of the MigrationResource update allowing to specify cancel.
         */
        interface WithCancel {
            /**
             * Specifies the cancel property: To trigger cancel for entire migration we need to send this flag as True.
             * 
             * @param cancel To trigger cancel for entire migration we need to send this flag as True.
             * @return the next definition stage.
             */
            Update withCancel(CancelEnum cancel);
        }

        /**
         * The stage of the MigrationResource update allowing to specify dbsToCancelMigrationOn.
         */
        interface WithDbsToCancelMigrationOn {
            /**
             * Specifies the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases
             * send cancel flag as True and database names in this array.
             * 
             * @param dbsToCancelMigrationOn When you want to trigger cancel for specific databases send cancel flag as
             * True and database names in this array.
             * @return the next definition stage.
             */
            Update withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn);
        }

        /**
         * The stage of the MigrationResource update allowing to specify migrationMode.
         */
        interface WithMigrationMode {
            /**
             * Specifies the migrationMode property: There are two types of migration modes Online and Offline.
             * 
             * @param migrationMode There are two types of migration modes Online and Offline.
             * @return the next definition stage.
             */
            Update withMigrationMode(MigrationMode migrationMode);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    MigrationResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    MigrationResource refresh(Context context);
}
