// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of migration resources.
 */
@Immutable
public final class MigrationResourceListResult implements JsonSerializable<MigrationResourceListResult> {
    /*
     * A list of migration resources.
     */
    private List<MigrationResourceInner> value;

    /*
     * The link used to get the next page of migrations.
     */
    private String nextLink;

    /**
     * Creates an instance of MigrationResourceListResult class.
     */
    public MigrationResourceListResult() {
    }

    /**
     * Get the value property: A list of migration resources.
     * 
     * @return the value value.
     */
    public List<MigrationResourceInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The link used to get the next page of migrations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationResourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationResourceListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationResourceListResult.
     */
    public static MigrationResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationResourceListResult deserializedMigrationResourceListResult = new MigrationResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MigrationResourceInner> value
                        = reader.readArray(reader1 -> MigrationResourceInner.fromJson(reader1));
                    deserializedMigrationResourceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedMigrationResourceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationResourceListResult;
        });
    }
}
