// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Migration secret parameters.
 */
@Fluent
public final class MigrationSecretParameters implements JsonSerializable<MigrationSecretParameters> {
    /*
     * Admin credentials for source and target servers
     */
    private AdminCredentials adminCredentials;

    /*
     * Gets or sets the username for the source server. This user need not be an admin.
     */
    private String sourceServerUsername;

    /*
     * Gets or sets the username for the target server. This user need not be an admin.
     */
    private String targetServerUsername;

    /**
     * Creates an instance of MigrationSecretParameters class.
     */
    public MigrationSecretParameters() {
    }

    /**
     * Get the adminCredentials property: Admin credentials for source and target servers.
     * 
     * @return the adminCredentials value.
     */
    public AdminCredentials adminCredentials() {
        return this.adminCredentials;
    }

    /**
     * Set the adminCredentials property: Admin credentials for source and target servers.
     * 
     * @param adminCredentials the adminCredentials value to set.
     * @return the MigrationSecretParameters object itself.
     */
    public MigrationSecretParameters withAdminCredentials(AdminCredentials adminCredentials) {
        this.adminCredentials = adminCredentials;
        return this;
    }

    /**
     * Get the sourceServerUsername property: Gets or sets the username for the source server. This user need not be an
     * admin.
     * 
     * @return the sourceServerUsername value.
     */
    public String sourceServerUsername() {
        return this.sourceServerUsername;
    }

    /**
     * Set the sourceServerUsername property: Gets or sets the username for the source server. This user need not be an
     * admin.
     * 
     * @param sourceServerUsername the sourceServerUsername value to set.
     * @return the MigrationSecretParameters object itself.
     */
    public MigrationSecretParameters withSourceServerUsername(String sourceServerUsername) {
        this.sourceServerUsername = sourceServerUsername;
        return this;
    }

    /**
     * Get the targetServerUsername property: Gets or sets the username for the target server. This user need not be an
     * admin.
     * 
     * @return the targetServerUsername value.
     */
    public String targetServerUsername() {
        return this.targetServerUsername;
    }

    /**
     * Set the targetServerUsername property: Gets or sets the username for the target server. This user need not be an
     * admin.
     * 
     * @param targetServerUsername the targetServerUsername value to set.
     * @return the MigrationSecretParameters object itself.
     */
    public MigrationSecretParameters withTargetServerUsername(String targetServerUsername) {
        this.targetServerUsername = targetServerUsername;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (adminCredentials() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property adminCredentials in model MigrationSecretParameters"));
        } else {
            adminCredentials().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MigrationSecretParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("adminCredentials", this.adminCredentials);
        jsonWriter.writeStringField("sourceServerUsername", this.sourceServerUsername);
        jsonWriter.writeStringField("targetServerUsername", this.targetServerUsername);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationSecretParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationSecretParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrationSecretParameters.
     */
    public static MigrationSecretParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationSecretParameters deserializedMigrationSecretParameters = new MigrationSecretParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("adminCredentials".equals(fieldName)) {
                    deserializedMigrationSecretParameters.adminCredentials = AdminCredentials.fromJson(reader);
                } else if ("sourceServerUsername".equals(fieldName)) {
                    deserializedMigrationSecretParameters.sourceServerUsername = reader.getString();
                } else if ("targetServerUsername".equals(fieldName)) {
                    deserializedMigrationSecretParameters.targetServerUsername = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationSecretParameters;
        });
    }
}
