// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Migration state.
 */
public final class MigrationState extends ExpandableStringEnum<MigrationState> {
    /**
     * Static value InProgress for MigrationState.
     */
    public static final MigrationState IN_PROGRESS = fromString("InProgress");

    /**
     * Static value WaitingForUserAction for MigrationState.
     */
    public static final MigrationState WAITING_FOR_USER_ACTION = fromString("WaitingForUserAction");

    /**
     * Static value Canceled for MigrationState.
     */
    public static final MigrationState CANCELED = fromString("Canceled");

    /**
     * Static value Failed for MigrationState.
     */
    public static final MigrationState FAILED = fromString("Failed");

    /**
     * Static value Succeeded for MigrationState.
     */
    public static final MigrationState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value ValidationFailed for MigrationState.
     */
    public static final MigrationState VALIDATION_FAILED = fromString("ValidationFailed");

    /**
     * Static value CleaningUp for MigrationState.
     */
    public static final MigrationState CLEANING_UP = fromString("CleaningUp");

    /**
     * Creates a new instance of MigrationState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MigrationState() {
    }

    /**
     * Creates or finds a MigrationState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MigrationState.
     */
    public static MigrationState fromString(String name) {
        return fromString(name, MigrationState.class);
    }

    /**
     * Gets known MigrationState values.
     * 
     * @return known MigrationState values.
     */
    public static Collection<MigrationState> values() {
        return values(MigrationState.class);
    }
}
