// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Migration status.
 */
@Immutable
public final class MigrationStatus implements JsonSerializable<MigrationStatus> {
    /*
     * State of migration
     */
    private MigrationState state;

    /*
     * Error message, if any, for the migration state
     */
    private String error;

    /*
     * Current Migration sub state details.
     */
    private MigrationSubStateDetails currentSubStateDetails;

    /**
     * Creates an instance of MigrationStatus class.
     */
    public MigrationStatus() {
    }

    /**
     * Get the state property: State of migration.
     * 
     * @return the state value.
     */
    public MigrationState state() {
        return this.state;
    }

    /**
     * Get the error property: Error message, if any, for the migration state.
     * 
     * @return the error value.
     */
    public String error() {
        return this.error;
    }

    /**
     * Get the currentSubStateDetails property: Current Migration sub state details.
     * 
     * @return the currentSubStateDetails value.
     */
    public MigrationSubStateDetails currentSubStateDetails() {
        return this.currentSubStateDetails;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (currentSubStateDetails() != null) {
            currentSubStateDetails().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationStatus.
     */
    public static MigrationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationStatus deserializedMigrationStatus = new MigrationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedMigrationStatus.state = MigrationState.fromString(reader.getString());
                } else if ("error".equals(fieldName)) {
                    deserializedMigrationStatus.error = reader.getString();
                } else if ("currentSubStateDetails".equals(fieldName)) {
                    deserializedMigrationStatus.currentSubStateDetails = MigrationSubStateDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationStatus;
        });
    }
}
