// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Migration sub state details.
 */
@Fluent
public final class MigrationSubStateDetails implements JsonSerializable<MigrationSubStateDetails> {
    /*
     * Migration sub state.
     */
    private MigrationSubState currentSubState;

    /*
     * Dictionary of <DbMigrationStatus>
     */
    private Map<String, DbMigrationStatus> dbDetails;

    /*
     * Details for the validation for migration
     */
    private ValidationDetails validationDetails;

    /**
     * Creates an instance of MigrationSubStateDetails class.
     */
    public MigrationSubStateDetails() {
    }

    /**
     * Get the currentSubState property: Migration sub state.
     * 
     * @return the currentSubState value.
     */
    public MigrationSubState currentSubState() {
        return this.currentSubState;
    }

    /**
     * Get the dbDetails property: Dictionary of &lt;DbMigrationStatus&gt;.
     * 
     * @return the dbDetails value.
     */
    public Map<String, DbMigrationStatus> dbDetails() {
        return this.dbDetails;
    }

    /**
     * Set the dbDetails property: Dictionary of &lt;DbMigrationStatus&gt;.
     * 
     * @param dbDetails the dbDetails value to set.
     * @return the MigrationSubStateDetails object itself.
     */
    public MigrationSubStateDetails withDbDetails(Map<String, DbMigrationStatus> dbDetails) {
        this.dbDetails = dbDetails;
        return this;
    }

    /**
     * Get the validationDetails property: Details for the validation for migration.
     * 
     * @return the validationDetails value.
     */
    public ValidationDetails validationDetails() {
        return this.validationDetails;
    }

    /**
     * Set the validationDetails property: Details for the validation for migration.
     * 
     * @param validationDetails the validationDetails value to set.
     * @return the MigrationSubStateDetails object itself.
     */
    public MigrationSubStateDetails withValidationDetails(ValidationDetails validationDetails) {
        this.validationDetails = validationDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dbDetails() != null) {
            dbDetails().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (validationDetails() != null) {
            validationDetails().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("dbDetails", this.dbDetails, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("validationDetails", this.validationDetails);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationSubStateDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationSubStateDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationSubStateDetails.
     */
    public static MigrationSubStateDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationSubStateDetails deserializedMigrationSubStateDetails = new MigrationSubStateDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("currentSubState".equals(fieldName)) {
                    deserializedMigrationSubStateDetails.currentSubState
                        = MigrationSubState.fromString(reader.getString());
                } else if ("dbDetails".equals(fieldName)) {
                    Map<String, DbMigrationStatus> dbDetails
                        = reader.readMap(reader1 -> DbMigrationStatus.fromJson(reader1));
                    deserializedMigrationSubStateDetails.dbDetails = dbDetails;
                } else if ("validationDetails".equals(fieldName)) {
                    deserializedMigrationSubStateDetails.validationDetails = ValidationDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationSubStateDetails;
        });
    }
}
