// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of Migrations.
 */
public interface Migrations {
    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response}.
     */
    Response<MigrationResource> getWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, Context context);

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration.
     */
    MigrationResource get(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName);

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, Context context);

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName);

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedIterable}.
     */
    PagedIterable<MigrationResource> listByTargetServer(String subscriptionId, String resourceGroupName,
        String targetDbServerName);

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedIterable}.
     */
    PagedIterable<MigrationResource> listByTargetServer(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationListFilter migrationListFilter, Context context);

    /**
     * Gets details of a migration.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response}.
     */
    MigrationResource getById(String id);

    /**
     * Gets details of a migration.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response}.
     */
    Response<MigrationResource> getByIdWithResponse(String id, Context context);

    /**
     * Deletes a migration.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes a migration.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new MigrationResource resource.
     * 
     * @param name resource name.
     * @return the first stage of the new MigrationResource definition.
     */
    MigrationResource.DefinitionStages.Blank define(String name);
}
