// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.NameAvailabilityInner;

/**
 * An immutable client-side representation of NameAvailability.
 */
public interface NameAvailability {
    /**
     * Gets the nameAvailable property: Indicates if the resource name is available.
     * 
     * @return the nameAvailable value.
     */
    Boolean nameAvailable();

    /**
     * Gets the reason property: The reason why the given name is not available.
     * 
     * @return the reason value.
     */
    CheckNameAvailabilityReason reason();

    /**
     * Gets the message property: Detailed reason why the given name is available.
     * 
     * @return the message value.
     */
    String message();

    /**
     * Gets the name property: name of the PostgreSQL server.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: type of the server.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the inner com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.NameAvailabilityInner object.
     * 
     * @return the inner object.
     */
    NameAvailabilityInner innerModel();
}
