// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network properties of a server.
 */
@Fluent
public final class Network implements JsonSerializable<Network> {
    /*
     * public network access is enabled or not
     */
    private ServerPublicNetworkAccessState publicNetworkAccess;

    /*
     * Delegated subnet arm resource id. This is required to be passed during create, in case we want the server to be
     * VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for
     * Private DNS zone.
     */
    private String delegatedSubnetResourceId;

    /*
     * Private dns zone arm resource id. This is required to be passed during create, in case we want the server to be
     * VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for
     * Private DNS zone.
     */
    private String privateDnsZoneArmResourceId;

    /**
     * Creates an instance of Network class.
     */
    public Network() {
    }

    /**
     * Get the publicNetworkAccess property: public network access is enabled or not.
     * 
     * @return the publicNetworkAccess value.
     */
    public ServerPublicNetworkAccessState publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: public network access is enabled or not.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the Network object itself.
     */
    public Network withPublicNetworkAccess(ServerPublicNetworkAccessState publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the delegatedSubnetResourceId property: Delegated subnet arm resource id. This is required to be passed
     * during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass
     * this only if we want to update the value for Private DNS zone.
     * 
     * @return the delegatedSubnetResourceId value.
     */
    public String delegatedSubnetResourceId() {
        return this.delegatedSubnetResourceId;
    }

    /**
     * Set the delegatedSubnetResourceId property: Delegated subnet arm resource id. This is required to be passed
     * during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass
     * this only if we want to update the value for Private DNS zone.
     * 
     * @param delegatedSubnetResourceId the delegatedSubnetResourceId value to set.
     * @return the Network object itself.
     */
    public Network withDelegatedSubnetResourceId(String delegatedSubnetResourceId) {
        this.delegatedSubnetResourceId = delegatedSubnetResourceId;
        return this;
    }

    /**
     * Get the privateDnsZoneArmResourceId property: Private dns zone arm resource id. This is required to be passed
     * during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass
     * this only if we want to update the value for Private DNS zone.
     * 
     * @return the privateDnsZoneArmResourceId value.
     */
    public String privateDnsZoneArmResourceId() {
        return this.privateDnsZoneArmResourceId;
    }

    /**
     * Set the privateDnsZoneArmResourceId property: Private dns zone arm resource id. This is required to be passed
     * during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass
     * this only if we want to update the value for Private DNS zone.
     * 
     * @param privateDnsZoneArmResourceId the privateDnsZoneArmResourceId value to set.
     * @return the Network object itself.
     */
    public Network withPrivateDnsZoneArmResourceId(String privateDnsZoneArmResourceId) {
        this.privateDnsZoneArmResourceId = privateDnsZoneArmResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("delegatedSubnetResourceId", this.delegatedSubnetResourceId);
        jsonWriter.writeStringField("privateDnsZoneArmResourceId", this.privateDnsZoneArmResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Network from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Network if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Network.
     */
    public static Network fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Network deserializedNetwork = new Network();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNetwork.publicNetworkAccess
                        = ServerPublicNetworkAccessState.fromString(reader.getString());
                } else if ("delegatedSubnetResourceId".equals(fieldName)) {
                    deserializedNetwork.delegatedSubnetResourceId = reader.getString();
                } else if ("privateDnsZoneArmResourceId".equals(fieldName)) {
                    deserializedNetwork.privateDnsZoneArmResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetwork;
        });
    }
}
