// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * REST API operation definition.
 */
@Fluent
public final class Operation implements JsonSerializable<Operation> {
    /*
     * The name of the operation being performed on this particular object.
     */
    private String name;

    /*
     * The localized display information for this particular operation or action.
     */
    private OperationDisplay display;

    /*
     * Indicates whether the operation is a data action
     */
    private Boolean isDataAction;

    /*
     * The intended executor of the operation.
     */
    private OperationOrigin origin;

    /*
     * Additional descriptions for the operation.
     */
    private Map<String, Object> properties;

    /**
     * Creates an instance of Operation class.
     */
    public Operation() {
    }

    /**
     * Get the name property: The name of the operation being performed on this particular object.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the display property: The localized display information for this particular operation or action.
     * 
     * @return the display value.
     */
    public OperationDisplay display() {
        return this.display;
    }

    /**
     * Get the isDataAction property: Indicates whether the operation is a data action.
     * 
     * @return the isDataAction value.
     */
    public Boolean isDataAction() {
        return this.isDataAction;
    }

    /**
     * Set the isDataAction property: Indicates whether the operation is a data action.
     * 
     * @param isDataAction the isDataAction value to set.
     * @return the Operation object itself.
     */
    public Operation withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    /**
     * Get the origin property: The intended executor of the operation.
     * 
     * @return the origin value.
     */
    public OperationOrigin origin() {
        return this.origin;
    }

    /**
     * Get the properties property: Additional descriptions for the operation.
     * 
     * @return the properties value.
     */
    public Map<String, Object> properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (display() != null) {
            display().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Operation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Operation if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Operation.
     */
    public static Operation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Operation deserializedOperation = new Operation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOperation.name = reader.getString();
                } else if ("display".equals(fieldName)) {
                    deserializedOperation.display = OperationDisplay.fromJson(reader);
                } else if ("isDataAction".equals(fieldName)) {
                    deserializedOperation.isDataAction = reader.getNullable(JsonReader::getBoolean);
                } else if ("origin".equals(fieldName)) {
                    deserializedOperation.origin = OperationOrigin.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    Map<String, Object> properties = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedOperation.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperation;
        });
    }
}
