// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the
 * migration workflow will wait for a confirmation, if it detects that the database already exists.
 */
public final class OverwriteDbsInTargetEnum extends ExpandableStringEnum<OverwriteDbsInTargetEnum> {
    /**
     * Static value True for OverwriteDbsInTargetEnum.
     */
    public static final OverwriteDbsInTargetEnum TRUE = fromString("True");

    /**
     * Static value False for OverwriteDbsInTargetEnum.
     */
    public static final OverwriteDbsInTargetEnum FALSE = fromString("False");

    /**
     * Creates a new instance of OverwriteDbsInTargetEnum value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OverwriteDbsInTargetEnum() {
    }

    /**
     * Creates or finds a OverwriteDbsInTargetEnum from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OverwriteDbsInTargetEnum.
     */
    public static OverwriteDbsInTargetEnum fromString(String name) {
        return fromString(name, OverwriteDbsInTargetEnum.class);
    }

    /**
     * Gets known OverwriteDbsInTargetEnum values.
     * 
     * @return known OverwriteDbsInTargetEnum values.
     */
    public static Collection<OverwriteDbsInTargetEnum> values() {
        return values(OverwriteDbsInTargetEnum.class);
    }
}
