// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Sets the promote mode for a replica server. This is a write only property.
 */
public final class ReadReplicaPromoteMode extends ExpandableStringEnum<ReadReplicaPromoteMode> {
    /**
     * Static value standalone for ReadReplicaPromoteMode.
     */
    public static final ReadReplicaPromoteMode STANDALONE = fromString("standalone");

    /**
     * Static value switchover for ReadReplicaPromoteMode.
     */
    public static final ReadReplicaPromoteMode SWITCHOVER = fromString("switchover");

    /**
     * Creates a new instance of ReadReplicaPromoteMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ReadReplicaPromoteMode() {
    }

    /**
     * Creates or finds a ReadReplicaPromoteMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ReadReplicaPromoteMode.
     */
    public static ReadReplicaPromoteMode fromString(String name) {
        return fromString(name, ReadReplicaPromoteMode.class);
    }

    /**
     * Gets known ReadReplicaPromoteMode values.
     * 
     * @return known ReadReplicaPromoteMode values.
     */
    public static Collection<ReadReplicaPromoteMode> values() {
        return values(ReadReplicaPromoteMode.class);
    }
}
