// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Sets the promote options for a replica server. This is a write only property.
 */
public final class ReplicationPromoteOption extends ExpandableStringEnum<ReplicationPromoteOption> {
    /**
     * Static value planned for ReplicationPromoteOption.
     */
    public static final ReplicationPromoteOption PLANNED = fromString("planned");

    /**
     * Static value forced for ReplicationPromoteOption.
     */
    public static final ReplicationPromoteOption FORCED = fromString("forced");

    /**
     * Creates a new instance of ReplicationPromoteOption value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ReplicationPromoteOption() {
    }

    /**
     * Creates or finds a ReplicationPromoteOption from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ReplicationPromoteOption.
     */
    public static ReplicationPromoteOption fromString(String name) {
        return fromString(name, ReplicationPromoteOption.class);
    }

    /**
     * Gets known ReplicationPromoteOption values.
     * 
     * @return known ReplicationPromoteOption values.
     */
    public static Collection<ReplicationPromoteOption> values() {
        return values(ReplicationPromoteOption.class);
    }
}
