// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Gets the replication state of a replica server. This property is returned only for replicas api call. Supported
 * values are Active, Catchup, Provisioning, Updating, Broken, Reconfiguring.
 */
public final class ReplicationState extends ExpandableStringEnum<ReplicationState> {
    /**
     * Static value Active for ReplicationState.
     */
    public static final ReplicationState ACTIVE = fromString("Active");

    /**
     * Static value Catchup for ReplicationState.
     */
    public static final ReplicationState CATCHUP = fromString("Catchup");

    /**
     * Static value Provisioning for ReplicationState.
     */
    public static final ReplicationState PROVISIONING = fromString("Provisioning");

    /**
     * Static value Updating for ReplicationState.
     */
    public static final ReplicationState UPDATING = fromString("Updating");

    /**
     * Static value Broken for ReplicationState.
     */
    public static final ReplicationState BROKEN = fromString("Broken");

    /**
     * Static value Reconfiguring for ReplicationState.
     */
    public static final ReplicationState RECONFIGURING = fromString("Reconfiguring");

    /**
     * Creates a new instance of ReplicationState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ReplicationState() {
    }

    /**
     * Creates or finds a ReplicationState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ReplicationState.
     */
    public static ReplicationState fromString(String name) {
        return fromString(name, ReplicationState.class);
    }

    /**
     * Gets known ReplicationState values.
     * 
     * @return known ReplicationState values.
     */
    public static Collection<ReplicationState> values() {
        return values(ReplicationState.class);
    }
}
