// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationNameAvailabilityResourceInner;

/**
 * Resource collection API of ResourceProviders.
 */
public interface ResourceProviders {
    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability along with {@link Response}.
     */
    Response<MigrationNameAvailabilityResource> checkMigrationNameAvailabilityWithResponse(String subscriptionId,
        String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters,
        Context context);

    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability.
     */
    MigrationNameAvailabilityResource checkMigrationNameAvailability(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationNameAvailabilityResourceInner parameters);
}
