// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerPropertiesForUpdate;
import java.io.IOException;
import java.util.Map;

/**
 * Represents a server to be updated.
 */
@Fluent
public final class ServerForUpdate implements JsonSerializable<ServerForUpdate> {
    /*
     * The SKU (pricing tier) of the server.
     */
    private Sku sku;

    /*
     * Describes the identity of the application.
     */
    private UserAssignedIdentity identity;

    /*
     * Properties of the server.
     */
    private ServerPropertiesForUpdate innerProperties;

    /*
     * Application-specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of ServerForUpdate class.
     */
    public ServerForUpdate() {
    }

    /**
     * Get the sku property: The SKU (pricing tier) of the server.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU (pricing tier) of the server.
     * 
     * @param sku the sku value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the identity property: Describes the identity of the application.
     * 
     * @return the identity value.
     */
    public UserAssignedIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Describes the identity of the application.
     * 
     * @param identity the identity value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the server.
     * 
     * @return the innerProperties value.
     */
    private ServerPropertiesForUpdate innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Application-specific metadata in the form of key-value pairs.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application-specific metadata in the form of key-value pairs.
     * 
     * @param tags the tags value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is trying to switch to password authentication and does not have default administrator login.
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is trying to switch to password authentication and does not have default administrator login.
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The password of the administrator login.
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: The password of the administrator login.
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the version property: PostgreSQL Server version. Version 16 is currently not supported for MVU.
     * 
     * @return the version value.
     */
    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: PostgreSQL Server version. Version 16 is currently not supported for MVU.
     * 
     * @param version the version value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the storage property: Storage properties of a server.
     * 
     * @return the storage value.
     */
    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    /**
     * Set the storage property: Storage properties of a server.
     * 
     * @param storage the storage value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    /**
     * Get the backup property: Backup properties of a server.
     * 
     * @return the backup value.
     */
    public Backup backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    /**
     * Set the backup property: Backup properties of a server.
     * 
     * @param backup the backup value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withBackup(Backup backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    /**
     * Get the highAvailability property: High availability properties of a server.
     * 
     * @return the highAvailability value.
     */
    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    /**
     * Set the highAvailability property: High availability properties of a server.
     * 
     * @param highAvailability the highAvailability value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    /**
     * Get the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @return the maintenanceWindow value.
     */
    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    /**
     * Set the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @param maintenanceWindow the maintenanceWindow value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    /**
     * Get the authConfig property: AuthConfig properties of a server.
     * 
     * @return the authConfig value.
     */
    public AuthConfig authConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().authConfig();
    }

    /**
     * Set the authConfig property: AuthConfig properties of a server.
     * 
     * @param authConfig the authConfig value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withAuthConfig(AuthConfig authConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withAuthConfig(authConfig);
        return this;
    }

    /**
     * Get the dataEncryption property: Data encryption properties of a server.
     * 
     * @return the dataEncryption value.
     */
    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    /**
     * Set the dataEncryption property: Data encryption properties of a server.
     * 
     * @param dataEncryption the dataEncryption value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    /**
     * Get the createMode property: The mode to update a new PostgreSQL server.
     * 
     * @return the createMode value.
     */
    public CreateModeForUpdate createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    /**
     * Set the createMode property: The mode to update a new PostgreSQL server.
     * 
     * @param createMode the createMode value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withCreateMode(CreateModeForUpdate createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    /**
     * Get the replicationRole property: Replication role of the server.
     * 
     * @return the replicationRole value.
     */
    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    /**
     * Set the replicationRole property: Replication role of the server.
     * 
     * @param replicationRole the replicationRole value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    /**
     * Get the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @return the replica value.
     */
    public Replica replica() {
        return this.innerProperties() == null ? null : this.innerProperties().replica();
    }

    /**
     * Set the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @param replica the replica value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withReplica(Replica replica) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withReplica(replica);
        return this;
    }

    /**
     * Get the network property: Network properties of a server. These are required to be passed only in case if server
     * is a private access server.
     * 
     * @return the network value.
     */
    public Network network() {
        return this.innerProperties() == null ? null : this.innerProperties().network();
    }

    /**
     * Set the network property: Network properties of a server. These are required to be passed only in case if server
     * is a private access server.
     * 
     * @param network the network value to set.
     * @return the ServerForUpdate object itself.
     */
    public ServerForUpdate withNetwork(Network network) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerPropertiesForUpdate();
        }
        this.innerProperties().withNetwork(network);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerForUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerForUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerForUpdate.
     */
    public static ServerForUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerForUpdate deserializedServerForUpdate = new ServerForUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sku".equals(fieldName)) {
                    deserializedServerForUpdate.sku = Sku.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedServerForUpdate.identity = UserAssignedIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedServerForUpdate.innerProperties = ServerPropertiesForUpdate.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerForUpdate.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerForUpdate;
        });
    }
}
