// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A state of a HA server that is visible to user.
 */
public final class ServerHAState extends ExpandableStringEnum<ServerHAState> {
    /**
     * Static value NotEnabled for ServerHAState.
     */
    public static final ServerHAState NOT_ENABLED = fromString("NotEnabled");

    /**
     * Static value CreatingStandby for ServerHAState.
     */
    public static final ServerHAState CREATING_STANDBY = fromString("CreatingStandby");

    /**
     * Static value ReplicatingData for ServerHAState.
     */
    public static final ServerHAState REPLICATING_DATA = fromString("ReplicatingData");

    /**
     * Static value FailingOver for ServerHAState.
     */
    public static final ServerHAState FAILING_OVER = fromString("FailingOver");

    /**
     * Static value Healthy for ServerHAState.
     */
    public static final ServerHAState HEALTHY = fromString("Healthy");

    /**
     * Static value RemovingStandby for ServerHAState.
     */
    public static final ServerHAState REMOVING_STANDBY = fromString("RemovingStandby");

    /**
     * Creates a new instance of ServerHAState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ServerHAState() {
    }

    /**
     * Creates or finds a ServerHAState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ServerHAState.
     */
    public static ServerHAState fromString(String name) {
        return fromString(name, ServerHAState.class);
    }

    /**
     * Gets known ServerHAState values.
     * 
     * @return known ServerHAState values.
     */
    public static Collection<ServerHAState> values() {
        return values(ServerHAState.class);
    }
}
