// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Sku information related properties of a server.
 */
@Fluent
public final class ServerSku implements JsonSerializable<ServerSku> {
    /*
     * The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
     */
    private String name;

    /*
     * The tier of the particular SKU, e.g. Burstable.
     */
    private SkuTier tier;

    /**
     * Creates an instance of ServerSku class.
     */
    public ServerSku() {
    }

    /**
     * Get the name property: The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
     * 
     * @param name the name value to set.
     * @return the ServerSku object itself.
     */
    public ServerSku withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: The tier of the particular SKU, e.g. Burstable.
     * 
     * @return the tier value.
     */
    public SkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: The tier of the particular SKU, e.g. Burstable.
     * 
     * @param tier the tier value to set.
     * @return the ServerSku object itself.
     */
    public ServerSku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerSku if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the ServerSku.
     */
    public static ServerSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerSku deserializedServerSku = new ServerSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedServerSku.name = reader.getString();
                } else if ("tier".equals(fieldName)) {
                    deserializedServerSku.tier = SkuTier.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerSku;
        });
    }
}
