// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Sku capability.
 */
@Immutable
public final class ServerSkuCapability extends CapabilityBase {
    /*
     * Sku name
     */
    private String name;

    /*
     * Supported vCores
     */
    private Integer vCores;

    /*
     * Supported IOPS
     */
    private Integer supportedIops;

    /*
     * Supported memory per vCore in MB
     */
    private Long supportedMemoryPerVcoreMb;

    /*
     * List of supported Availability Zones. E.g. "1", "2", "3"
     */
    private List<String> supportedZones;

    /*
     * Supported high availability mode
     */
    private List<HaMode> supportedHaMode;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /**
     * Creates an instance of ServerSkuCapability class.
     */
    public ServerSkuCapability() {
    }

    /**
     * Get the name property: Sku name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the vCores property: Supported vCores.
     * 
     * @return the vCores value.
     */
    public Integer vCores() {
        return this.vCores;
    }

    /**
     * Get the supportedIops property: Supported IOPS.
     * 
     * @return the supportedIops value.
     */
    public Integer supportedIops() {
        return this.supportedIops;
    }

    /**
     * Get the supportedMemoryPerVcoreMb property: Supported memory per vCore in MB.
     * 
     * @return the supportedMemoryPerVcoreMb value.
     */
    public Long supportedMemoryPerVcoreMb() {
        return this.supportedMemoryPerVcoreMb;
    }

    /**
     * Get the supportedZones property: List of supported Availability Zones. E.g. "1", "2", "3".
     * 
     * @return the supportedZones value.
     */
    public List<String> supportedZones() {
        return this.supportedZones;
    }

    /**
     * Get the supportedHaMode property: Supported high availability mode.
     * 
     * @return the supportedHaMode value.
     */
    public List<HaMode> supportedHaMode() {
        return this.supportedHaMode;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    @Override
    public String reason() {
        return this.reason;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerSkuCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerSkuCapability if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerSkuCapability.
     */
    public static ServerSkuCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerSkuCapability deserializedServerSkuCapability = new ServerSkuCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedServerSkuCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedServerSkuCapability.reason = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerSkuCapability.name = reader.getString();
                } else if ("vCores".equals(fieldName)) {
                    deserializedServerSkuCapability.vCores = reader.getNullable(JsonReader::getInt);
                } else if ("supportedIops".equals(fieldName)) {
                    deserializedServerSkuCapability.supportedIops = reader.getNullable(JsonReader::getInt);
                } else if ("supportedMemoryPerVcoreMb".equals(fieldName)) {
                    deserializedServerSkuCapability.supportedMemoryPerVcoreMb = reader.getNullable(JsonReader::getLong);
                } else if ("supportedZones".equals(fieldName)) {
                    List<String> supportedZones = reader.readArray(reader1 -> reader1.getString());
                    deserializedServerSkuCapability.supportedZones = supportedZones;
                } else if ("supportedHaMode".equals(fieldName)) {
                    List<HaMode> supportedHaMode = reader.readArray(reader1 -> HaMode.fromString(reader1.getString()));
                    deserializedServerSkuCapability.supportedHaMode = supportedHaMode;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerSkuCapability;
        });
    }
}
