// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The version of a server.
 */
public final class ServerVersion extends ExpandableStringEnum<ServerVersion> {
    /**
     * Static value 16 for ServerVersion.
     */
    public static final ServerVersion ONE_SIX = fromString("16");

    /**
     * Static value 15 for ServerVersion.
     */
    public static final ServerVersion ONE_FIVE = fromString("15");

    /**
     * Static value 14 for ServerVersion.
     */
    public static final ServerVersion ONE_FOUR = fromString("14");

    /**
     * Static value 13 for ServerVersion.
     */
    public static final ServerVersion ONE_THREE = fromString("13");

    /**
     * Static value 12 for ServerVersion.
     */
    public static final ServerVersion ONE_TWO = fromString("12");

    /**
     * Static value 11 for ServerVersion.
     */
    public static final ServerVersion ONE_ONE = fromString("11");

    /**
     * Creates a new instance of ServerVersion value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ServerVersion() {
    }

    /**
     * Creates or finds a ServerVersion from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ServerVersion.
     */
    public static ServerVersion fromString(String name) {
        return fromString(name, ServerVersion.class);
    }

    /**
     * Gets known ServerVersion values.
     * 
     * @return known ServerVersion values.
     */
    public static Collection<ServerVersion> values() {
        return values(ServerVersion.class);
    }
}
