// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Server version capabilities.
 */
@Immutable
public final class ServerVersionCapability extends CapabilityBase {
    /*
     * Server version
     */
    private String name;

    /*
     * Supported servers versions to upgrade
     */
    private List<String> supportedVersionsToUpgrade;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /**
     * Creates an instance of ServerVersionCapability class.
     */
    public ServerVersionCapability() {
    }

    /**
     * Get the name property: Server version.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedVersionsToUpgrade property: Supported servers versions to upgrade.
     * 
     * @return the supportedVersionsToUpgrade value.
     */
    public List<String> supportedVersionsToUpgrade() {
        return this.supportedVersionsToUpgrade;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    @Override
    public String reason() {
        return this.reason;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerVersionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerVersionCapability if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerVersionCapability.
     */
    public static ServerVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerVersionCapability deserializedServerVersionCapability = new ServerVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedServerVersionCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedServerVersionCapability.reason = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerVersionCapability.name = reader.getString();
                } else if ("supportedVersionsToUpgrade".equals(fieldName)) {
                    List<String> supportedVersionsToUpgrade = reader.readArray(reader1 -> reader1.getString());
                    deserializedServerVersionCapability.supportedVersionsToUpgrade = supportedVersionsToUpgrade;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerVersionCapability;
        });
    }
}
