// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Supported SSL modes for migration. VerifyFull is the recommended SSL mode for Single server migration. Prefer,
 * Require are recommended SSL modes for other source types.
 */
public final class SslMode extends ExpandableStringEnum<SslMode> {
    /**
     * Static value Prefer for SslMode.
     */
    public static final SslMode PREFER = fromString("Prefer");

    /**
     * Static value Require for SslMode.
     */
    public static final SslMode REQUIRE = fromString("Require");

    /**
     * Static value VerifyCA for SslMode.
     */
    public static final SslMode VERIFY_CA = fromString("VerifyCA");

    /**
     * Static value VerifyFull for SslMode.
     */
    public static final SslMode VERIFY_FULL = fromString("VerifyFull");

    /**
     * Creates a new instance of SslMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SslMode() {
    }

    /**
     * Creates or finds a SslMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SslMode.
     */
    public static SslMode fromString(String name) {
        return fromString(name, SslMode.class);
    }

    /**
     * Gets known SslMode values.
     * 
     * @return known SslMode values.
     */
    public static Collection<SslMode> values() {
        return values(SslMode.class);
    }
}
