// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A value indicating whether storage auto-grow is supported in this region. "Enabled" means storage auto-grow is
 * supported. "Disabled" stands for storage auto-grow is not supported.
 */
public final class StorageAutoGrowthSupportedEnum extends ExpandableStringEnum<StorageAutoGrowthSupportedEnum> {
    /**
     * Static value Enabled for StorageAutoGrowthSupportedEnum.
     */
    public static final StorageAutoGrowthSupportedEnum ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for StorageAutoGrowthSupportedEnum.
     */
    public static final StorageAutoGrowthSupportedEnum DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of StorageAutoGrowthSupportedEnum value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageAutoGrowthSupportedEnum() {
    }

    /**
     * Creates or finds a StorageAutoGrowthSupportedEnum from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageAutoGrowthSupportedEnum.
     */
    public static StorageAutoGrowthSupportedEnum fromString(String name) {
        return fromString(name, StorageAutoGrowthSupportedEnum.class);
    }

    /**
     * Gets known StorageAutoGrowthSupportedEnum values.
     * 
     * @return known StorageAutoGrowthSupportedEnum values.
     */
    public static Collection<StorageAutoGrowthSupportedEnum> values() {
        return values(StorageAutoGrowthSupportedEnum.class);
    }
}
