// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Storage edition capability.
 */
@Immutable
public final class StorageEditionCapability extends CapabilityBase {
    /*
     * Storage edition name
     */
    private String name;

    /*
     * Default storage size in MB for storage edition
     */
    private Long defaultStorageSizeMb;

    /*
     * Flexible server supported storage range in MB
     */
    private List<StorageMbCapability> supportedStorageMb;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /**
     * Creates an instance of StorageEditionCapability class.
     */
    public StorageEditionCapability() {
    }

    /**
     * Get the name property: Storage edition name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the defaultStorageSizeMb property: Default storage size in MB for storage edition.
     * 
     * @return the defaultStorageSizeMb value.
     */
    public Long defaultStorageSizeMb() {
        return this.defaultStorageSizeMb;
    }

    /**
     * Get the supportedStorageMb property: Flexible server supported storage range in MB.
     * 
     * @return the supportedStorageMb value.
     */
    public List<StorageMbCapability> supportedStorageMb() {
        return this.supportedStorageMb;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    @Override
    public String reason() {
        return this.reason;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (supportedStorageMb() != null) {
            supportedStorageMb().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageEditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageEditionCapability if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageEditionCapability.
     */
    public static StorageEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageEditionCapability deserializedStorageEditionCapability = new StorageEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedStorageEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedStorageEditionCapability.reason = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStorageEditionCapability.name = reader.getString();
                } else if ("defaultStorageSizeMb".equals(fieldName)) {
                    deserializedStorageEditionCapability.defaultStorageSizeMb = reader.getNullable(JsonReader::getLong);
                } else if ("supportedStorageMb".equals(fieldName)) {
                    List<StorageMbCapability> supportedStorageMb
                        = reader.readArray(reader1 -> StorageMbCapability.fromJson(reader1));
                    deserializedStorageEditionCapability.supportedStorageMb = supportedStorageMb;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageEditionCapability;
        });
    }
}
