// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Storage type for the server. Allowed values are Premium_LRS and PremiumV2_LRS, and default is Premium_LRS if not
 * specified.
 */
public final class StorageType extends ExpandableStringEnum<StorageType> {
    /**
     * Static value Premium_LRS for StorageType.
     */
    public static final StorageType PREMIUM_LRS = fromString("Premium_LRS");

    /**
     * Static value PremiumV2_LRS for StorageType.
     */
    public static final StorageType PREMIUM_V2_LRS = fromString("PremiumV2_LRS");

    /**
     * Creates a new instance of StorageType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageType() {
    }

    /**
     * Creates or finds a StorageType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageType.
     */
    public static StorageType fromString(String name) {
        return fromString(name, StorageType.class);
    }

    /**
     * Gets known StorageType values.
     * 
     * @return known StorageType values.
     */
    public static Collection<StorageType> values() {
        return values(StorageType.class);
    }
}
