// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Information describing the identities associated with this application.
 */
@Fluent
public final class UserAssignedIdentity implements JsonSerializable<UserAssignedIdentity> {
    /*
     * represents user assigned identities map.
     */
    private Map<String, UserIdentity> userAssignedIdentities;

    /*
     * the types of identities associated with this resource; currently restricted to 'None and UserAssigned'
     */
    private IdentityType type;

    /*
     * Tenant id of the server.
     */
    private String tenantId;

    /**
     * Creates an instance of UserAssignedIdentity class.
     */
    public UserAssignedIdentity() {
    }

    /**
     * Get the userAssignedIdentities property: represents user assigned identities map.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, UserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: represents user assigned identities map.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withUserAssignedIdentities(Map<String, UserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Get the type property: the types of identities associated with this resource; currently restricted to 'None and
     * UserAssigned'.
     * 
     * @return the type value.
     */
    public IdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: the types of identities associated with this resource; currently restricted to 'None and
     * UserAssigned'.
     * 
     * @param type the type value to set.
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the tenantId property: Tenant id of the server.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model UserAssignedIdentity"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UserAssignedIdentity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserAssignedIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserAssignedIdentity if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserAssignedIdentity.
     */
    public static UserAssignedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserAssignedIdentity deserializedUserAssignedIdentity = new UserAssignedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedUserAssignedIdentity.type = IdentityType.fromString(reader.getString());
                } else if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, UserIdentity> userAssignedIdentities
                        = reader.readMap(reader1 -> UserIdentity.fromJson(reader1));
                    deserializedUserAssignedIdentity.userAssignedIdentities = userAssignedIdentities;
                } else if ("tenantId".equals(fieldName)) {
                    deserializedUserAssignedIdentity.tenantId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserAssignedIdentity;
        });
    }
}
