// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Details for the validation for migration.
 */
@Fluent
public final class ValidationDetails implements JsonSerializable<ValidationDetails> {
    /*
     * Validation status for migration
     */
    private ValidationState status;

    /*
     * Validation Start date-time in UTC
     */
    private OffsetDateTime validationStartTimeInUtc;

    /*
     * Validation End date-time in UTC
     */
    private OffsetDateTime validationEndTimeInUtc;

    /*
     * Details of server level validations
     */
    private List<ValidationSummaryItem> serverLevelValidationDetails;

    /*
     * Details of server level validations
     */
    private List<DbLevelValidationStatus> dbLevelValidationDetails;

    /**
     * Creates an instance of ValidationDetails class.
     */
    public ValidationDetails() {
    }

    /**
     * Get the status property: Validation status for migration.
     * 
     * @return the status value.
     */
    public ValidationState status() {
        return this.status;
    }

    /**
     * Set the status property: Validation status for migration.
     * 
     * @param status the status value to set.
     * @return the ValidationDetails object itself.
     */
    public ValidationDetails withStatus(ValidationState status) {
        this.status = status;
        return this;
    }

    /**
     * Get the validationStartTimeInUtc property: Validation Start date-time in UTC.
     * 
     * @return the validationStartTimeInUtc value.
     */
    public OffsetDateTime validationStartTimeInUtc() {
        return this.validationStartTimeInUtc;
    }

    /**
     * Set the validationStartTimeInUtc property: Validation Start date-time in UTC.
     * 
     * @param validationStartTimeInUtc the validationStartTimeInUtc value to set.
     * @return the ValidationDetails object itself.
     */
    public ValidationDetails withValidationStartTimeInUtc(OffsetDateTime validationStartTimeInUtc) {
        this.validationStartTimeInUtc = validationStartTimeInUtc;
        return this;
    }

    /**
     * Get the validationEndTimeInUtc property: Validation End date-time in UTC.
     * 
     * @return the validationEndTimeInUtc value.
     */
    public OffsetDateTime validationEndTimeInUtc() {
        return this.validationEndTimeInUtc;
    }

    /**
     * Set the validationEndTimeInUtc property: Validation End date-time in UTC.
     * 
     * @param validationEndTimeInUtc the validationEndTimeInUtc value to set.
     * @return the ValidationDetails object itself.
     */
    public ValidationDetails withValidationEndTimeInUtc(OffsetDateTime validationEndTimeInUtc) {
        this.validationEndTimeInUtc = validationEndTimeInUtc;
        return this;
    }

    /**
     * Get the serverLevelValidationDetails property: Details of server level validations.
     * 
     * @return the serverLevelValidationDetails value.
     */
    public List<ValidationSummaryItem> serverLevelValidationDetails() {
        return this.serverLevelValidationDetails;
    }

    /**
     * Set the serverLevelValidationDetails property: Details of server level validations.
     * 
     * @param serverLevelValidationDetails the serverLevelValidationDetails value to set.
     * @return the ValidationDetails object itself.
     */
    public ValidationDetails
        withServerLevelValidationDetails(List<ValidationSummaryItem> serverLevelValidationDetails) {
        this.serverLevelValidationDetails = serverLevelValidationDetails;
        return this;
    }

    /**
     * Get the dbLevelValidationDetails property: Details of server level validations.
     * 
     * @return the dbLevelValidationDetails value.
     */
    public List<DbLevelValidationStatus> dbLevelValidationDetails() {
        return this.dbLevelValidationDetails;
    }

    /**
     * Set the dbLevelValidationDetails property: Details of server level validations.
     * 
     * @param dbLevelValidationDetails the dbLevelValidationDetails value to set.
     * @return the ValidationDetails object itself.
     */
    public ValidationDetails withDbLevelValidationDetails(List<DbLevelValidationStatus> dbLevelValidationDetails) {
        this.dbLevelValidationDetails = dbLevelValidationDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serverLevelValidationDetails() != null) {
            serverLevelValidationDetails().forEach(e -> e.validate());
        }
        if (dbLevelValidationDetails() != null) {
            dbLevelValidationDetails().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("validationStartTimeInUtc",
            this.validationStartTimeInUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validationStartTimeInUtc));
        jsonWriter.writeStringField("validationEndTimeInUtc",
            this.validationEndTimeInUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validationEndTimeInUtc));
        jsonWriter.writeArrayField("serverLevelValidationDetails", this.serverLevelValidationDetails,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("dbLevelValidationDetails", this.dbLevelValidationDetails,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidationDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidationDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ValidationDetails.
     */
    public static ValidationDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidationDetails deserializedValidationDetails = new ValidationDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedValidationDetails.status = ValidationState.fromString(reader.getString());
                } else if ("validationStartTimeInUtc".equals(fieldName)) {
                    deserializedValidationDetails.validationStartTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("validationEndTimeInUtc".equals(fieldName)) {
                    deserializedValidationDetails.validationEndTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("serverLevelValidationDetails".equals(fieldName)) {
                    List<ValidationSummaryItem> serverLevelValidationDetails
                        = reader.readArray(reader1 -> ValidationSummaryItem.fromJson(reader1));
                    deserializedValidationDetails.serverLevelValidationDetails = serverLevelValidationDetails;
                } else if ("dbLevelValidationDetails".equals(fieldName)) {
                    List<DbLevelValidationStatus> dbLevelValidationDetails
                        = reader.readArray(reader1 -> DbLevelValidationStatus.fromJson(reader1));
                    deserializedValidationDetails.dbLevelValidationDetails = dbLevelValidationDetails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidationDetails;
        });
    }
}
