// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Validation message object.
 */
@Fluent
public final class ValidationMessage implements JsonSerializable<ValidationMessage> {
    /*
     * Severity of validation message
     */
    private ValidationState state;

    /*
     * Validation message string
     */
    private String message;

    /**
     * Creates an instance of ValidationMessage class.
     */
    public ValidationMessage() {
    }

    /**
     * Get the state property: Severity of validation message.
     * 
     * @return the state value.
     */
    public ValidationState state() {
        return this.state;
    }

    /**
     * Set the state property: Severity of validation message.
     * 
     * @param state the state value to set.
     * @return the ValidationMessage object itself.
     */
    public ValidationMessage withState(ValidationState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the message property: Validation message string.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Validation message string.
     * 
     * @param message the message value to set.
     * @return the ValidationMessage object itself.
     */
    public ValidationMessage withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidationMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidationMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ValidationMessage.
     */
    public static ValidationMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidationMessage deserializedValidationMessage = new ValidationMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedValidationMessage.state = ValidationState.fromString(reader.getString());
                } else if ("message".equals(fieldName)) {
                    deserializedValidationMessage.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidationMessage;
        });
    }
}
