// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Validation summary object.
 */
@Fluent
public final class ValidationSummaryItem implements JsonSerializable<ValidationSummaryItem> {
    /*
     * Validation type
     */
    private String type;

    /*
     * Validation status for migration
     */
    private ValidationState state;

    /*
     * Validation messages
     */
    private List<ValidationMessage> messages;

    /**
     * Creates an instance of ValidationSummaryItem class.
     */
    public ValidationSummaryItem() {
    }

    /**
     * Get the type property: Validation type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Validation type.
     * 
     * @param type the type value to set.
     * @return the ValidationSummaryItem object itself.
     */
    public ValidationSummaryItem withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the state property: Validation status for migration.
     * 
     * @return the state value.
     */
    public ValidationState state() {
        return this.state;
    }

    /**
     * Set the state property: Validation status for migration.
     * 
     * @param state the state value to set.
     * @return the ValidationSummaryItem object itself.
     */
    public ValidationSummaryItem withState(ValidationState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the messages property: Validation messages.
     * 
     * @return the messages value.
     */
    public List<ValidationMessage> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: Validation messages.
     * 
     * @param messages the messages value to set.
     * @return the ValidationSummaryItem object itself.
     */
    public ValidationSummaryItem withMessages(List<ValidationMessage> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (messages() != null) {
            messages().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidationSummaryItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidationSummaryItem if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ValidationSummaryItem.
     */
    public static ValidationSummaryItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidationSummaryItem deserializedValidationSummaryItem = new ValidationSummaryItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedValidationSummaryItem.type = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedValidationSummaryItem.state = ValidationState.fromString(reader.getString());
                } else if ("messages".equals(fieldName)) {
                    List<ValidationMessage> messages = reader.readArray(reader1 -> ValidationMessage.fromJson(reader1));
                    deserializedValidationSummaryItem.messages = messages;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidationSummaryItem;
        });
    }
}
