// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceInner;
import java.util.List;

/**
 * An immutable client-side representation of VirtualEndpointResource.
 */
public interface VirtualEndpointResource {
    /**
     * Gets the endpointType property: The endpoint type for the virtual endpoint.
     * 
     * @return the endpointType value.
     */
    VirtualEndpointType endpointType();

    /**
     * Gets the members property: List of members for a virtual endpoint.
     * 
     * @return the members value.
     */
    List<String> members();

    /**
     * Gets the virtualEndpoints property: List of virtual endpoints for a server.
     * 
     * @return the virtualEndpoints value.
     */
    List<String> virtualEndpoints();

    /**
     * Gets the id property: Fully qualified resource ID for the resource. E.g.
     * "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     * "Microsoft.Storage/storageAccounts".
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceInner
     * object.
     * 
     * @return the inner object.
     */
    VirtualEndpointResourceInner innerModel();

    /**
     * The entirety of the VirtualEndpointResource definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The VirtualEndpointResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the VirtualEndpointResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the VirtualEndpointResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serverName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serverName The name of the server.
             * @return the next definition stage.
             */
            WithCreate withExistingFlexibleServer(String resourceGroupName, String serverName);
        }

        /**
         * The stage of the VirtualEndpointResource definition which contains all the minimum required properties for
         * the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithEndpointType, DefinitionStages.WithMembers {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            VirtualEndpointResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            VirtualEndpointResource create(Context context);
        }

        /**
         * The stage of the VirtualEndpointResource definition allowing to specify endpointType.
         */
        interface WithEndpointType {
            /**
             * Specifies the endpointType property: The endpoint type for the virtual endpoint..
             * 
             * @param endpointType The endpoint type for the virtual endpoint.
             * @return the next definition stage.
             */
            WithCreate withEndpointType(VirtualEndpointType endpointType);
        }

        /**
         * The stage of the VirtualEndpointResource definition allowing to specify members.
         */
        interface WithMembers {
            /**
             * Specifies the members property: List of members for a virtual endpoint.
             * 
             * @param members List of members for a virtual endpoint.
             * @return the next definition stage.
             */
            WithCreate withMembers(List<String> members);
        }
    }

    /**
     * Begins update for the VirtualEndpointResource resource.
     * 
     * @return the stage of resource update.
     */
    VirtualEndpointResource.Update update();

    /**
     * The template for VirtualEndpointResource update.
     */
    interface Update extends UpdateStages.WithEndpointType, UpdateStages.WithMembers {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        VirtualEndpointResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        VirtualEndpointResource apply(Context context);
    }

    /**
     * The VirtualEndpointResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the VirtualEndpointResource update allowing to specify endpointType.
         */
        interface WithEndpointType {
            /**
             * Specifies the endpointType property: The endpoint type for the virtual endpoint..
             * 
             * @param endpointType The endpoint type for the virtual endpoint.
             * @return the next definition stage.
             */
            Update withEndpointType(VirtualEndpointType endpointType);
        }

        /**
         * The stage of the VirtualEndpointResource update allowing to specify members.
         */
        interface WithMembers {
            /**
             * Specifies the members property: List of members for a virtual endpoint.
             * 
             * @param members List of members for a virtual endpoint.
             * @return the next definition stage.
             */
            Update withMembers(List<String> members);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    VirtualEndpointResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    VirtualEndpointResource refresh(Context context);
}
