// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceProperties;
import java.io.IOException;
import java.util.List;

/**
 * Represents a virtual endpoint for a server.
 */
@Fluent
public class VirtualEndpointResourceForPatch implements JsonSerializable<VirtualEndpointResourceForPatch> {
    /*
     * Properties of the virtual endpoint resource.
     */
    private VirtualEndpointResourceProperties innerProperties;

    /**
     * Creates an instance of VirtualEndpointResourceForPatch class.
     */
    public VirtualEndpointResourceForPatch() {
    }

    /**
     * Get the innerProperties property: Properties of the virtual endpoint resource.
     * 
     * @return the innerProperties value.
     */
    private VirtualEndpointResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Set the innerProperties property: Properties of the virtual endpoint resource.
     * 
     * @param innerProperties the innerProperties value to set.
     * @return the VirtualEndpointResourceForPatch object itself.
     */
    VirtualEndpointResourceForPatch withInnerProperties(VirtualEndpointResourceProperties innerProperties) {
        this.innerProperties = innerProperties;
        return this;
    }

    /**
     * Get the endpointType property: The endpoint type for the virtual endpoint.
     * 
     * @return the endpointType value.
     */
    public VirtualEndpointType endpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointType();
    }

    /**
     * Set the endpointType property: The endpoint type for the virtual endpoint.
     * 
     * @param endpointType the endpointType value to set.
     * @return the VirtualEndpointResourceForPatch object itself.
     */
    public VirtualEndpointResourceForPatch withEndpointType(VirtualEndpointType endpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withEndpointType(endpointType);
        return this;
    }

    /**
     * Get the members property: List of members for a virtual endpoint.
     * 
     * @return the members value.
     */
    public List<String> members() {
        return this.innerProperties() == null ? null : this.innerProperties().members();
    }

    /**
     * Set the members property: List of members for a virtual endpoint.
     * 
     * @param members the members value to set.
     * @return the VirtualEndpointResourceForPatch object itself.
     */
    public VirtualEndpointResourceForPatch withMembers(List<String> members) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withMembers(members);
        return this;
    }

    /**
     * Get the virtualEndpoints property: List of virtual endpoints for a server.
     * 
     * @return the virtualEndpoints value.
     */
    public List<String> virtualEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualEndpoints();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualEndpointResourceForPatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualEndpointResourceForPatch if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualEndpointResourceForPatch.
     */
    public static VirtualEndpointResourceForPatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualEndpointResourceForPatch deserializedVirtualEndpointResourceForPatch
                = new VirtualEndpointResourceForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedVirtualEndpointResourceForPatch.innerProperties
                        = VirtualEndpointResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualEndpointResourceForPatch;
        });
    }
}
