// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Virtual network subnet usage parameter.
 */
@Fluent
public final class VirtualNetworkSubnetUsageParameter implements JsonSerializable<VirtualNetworkSubnetUsageParameter> {
    /*
     * Virtual network resource id.
     */
    private String virtualNetworkArmResourceId;

    /**
     * Creates an instance of VirtualNetworkSubnetUsageParameter class.
     */
    public VirtualNetworkSubnetUsageParameter() {
    }

    /**
     * Get the virtualNetworkArmResourceId property: Virtual network resource id.
     * 
     * @return the virtualNetworkArmResourceId value.
     */
    public String virtualNetworkArmResourceId() {
        return this.virtualNetworkArmResourceId;
    }

    /**
     * Set the virtualNetworkArmResourceId property: Virtual network resource id.
     * 
     * @param virtualNetworkArmResourceId the virtualNetworkArmResourceId value to set.
     * @return the VirtualNetworkSubnetUsageParameter object itself.
     */
    public VirtualNetworkSubnetUsageParameter withVirtualNetworkArmResourceId(String virtualNetworkArmResourceId) {
        this.virtualNetworkArmResourceId = virtualNetworkArmResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualNetworkArmResourceId", this.virtualNetworkArmResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkSubnetUsageParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkSubnetUsageParameter if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkSubnetUsageParameter.
     */
    public static VirtualNetworkSubnetUsageParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkSubnetUsageParameter deserializedVirtualNetworkSubnetUsageParameter
                = new VirtualNetworkSubnetUsageParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetworkArmResourceId".equals(fieldName)) {
                    deserializedVirtualNetworkSubnetUsageParameter.virtualNetworkArmResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkSubnetUsageParameter;
        });
    }
}
