// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A value indicating whether Zone Redundant HA and Geo-backup is supported in this region. "Enabled" means zone
 * redundant HA and geo-backup is supported. "Disabled" stands for zone redundant HA and geo-backup is not supported.
 */
public final class ZoneRedundantHaAndGeoBackupSupportedEnum
    extends ExpandableStringEnum<ZoneRedundantHaAndGeoBackupSupportedEnum> {
    /**
     * Static value Enabled for ZoneRedundantHaAndGeoBackupSupportedEnum.
     */
    public static final ZoneRedundantHaAndGeoBackupSupportedEnum ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for ZoneRedundantHaAndGeoBackupSupportedEnum.
     */
    public static final ZoneRedundantHaAndGeoBackupSupportedEnum DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of ZoneRedundantHaAndGeoBackupSupportedEnum value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ZoneRedundantHaAndGeoBackupSupportedEnum() {
    }

    /**
     * Creates or finds a ZoneRedundantHaAndGeoBackupSupportedEnum from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ZoneRedundantHaAndGeoBackupSupportedEnum.
     */
    public static ZoneRedundantHaAndGeoBackupSupportedEnum fromString(String name) {
        return fromString(name, ZoneRedundantHaAndGeoBackupSupportedEnum.class);
    }

    /**
     * Gets known ZoneRedundantHaAndGeoBackupSupportedEnum values.
     * 
     * @return known ZoneRedundantHaAndGeoBackupSupportedEnum values.
     */
    public static Collection<ZoneRedundantHaAndGeoBackupSupportedEnum> values() {
        return values(ZoneRedundantHaAndGeoBackupSupportedEnum.class);
    }
}
