// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A value indicating whether Zone Redundant HA is supported in this region. "Enabled" means zone redundant HA is
 * supported. "Disabled" stands for zone redundant HA is not supported.
 */
public final class ZoneRedundantHaSupportedEnum extends ExpandableStringEnum<ZoneRedundantHaSupportedEnum> {
    /**
     * Static value Enabled for ZoneRedundantHaSupportedEnum.
     */
    public static final ZoneRedundantHaSupportedEnum ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for ZoneRedundantHaSupportedEnum.
     */
    public static final ZoneRedundantHaSupportedEnum DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of ZoneRedundantHaSupportedEnum value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ZoneRedundantHaSupportedEnum() {
    }

    /**
     * Creates or finds a ZoneRedundantHaSupportedEnum from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ZoneRedundantHaSupportedEnum.
     */
    public static ZoneRedundantHaSupportedEnum fromString(String name) {
        return fromString(name, ZoneRedundantHaSupportedEnum.class);
    }

    /**
     * Gets known ZoneRedundantHaSupportedEnum values.
     * 
     * @return known ZoneRedundantHaSupportedEnum values.
     */
    public static Collection<ZoneRedundantHaSupportedEnum> values() {
        return values(ZoneRedundantHaSupportedEnum.class);
    }
}
