/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.AdministratorProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrincipalType;
import java.io.IOException;

public final class ActiveDirectoryAdministratorInner
extends ProxyResource {
    private AdministratorProperties innerProperties = new AdministratorProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ActiveDirectoryAdministratorInner.class);

    private AdministratorProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    public ActiveDirectoryAdministratorInner withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    public ActiveDirectoryAdministratorInner withPrincipalName(String principalName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withPrincipalName(principalName);
        return this;
    }

    public String objectId() {
        return this.innerProperties() == null ? null : this.innerProperties().objectId();
    }

    public ActiveDirectoryAdministratorInner withObjectId(String objectId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withObjectId(objectId);
        return this;
    }

    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public ActiveDirectoryAdministratorInner withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ActiveDirectoryAdministratorInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ActiveDirectoryAdministratorInner fromJson(JsonReader jsonReader) throws IOException {
        return (ActiveDirectoryAdministratorInner)((Object)jsonReader.readObject(reader -> {
            ActiveDirectoryAdministratorInner deserializedActiveDirectoryAdministratorInner = new ActiveDirectoryAdministratorInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.innerProperties = AdministratorProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveDirectoryAdministratorInner;
        }));
    }
}

