/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CancelEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbServerMetadata;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceDbEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDbsInTargetEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SourceType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SslMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigrationEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutoverEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class MigrationResourceProperties
implements JsonSerializable<MigrationResourceProperties> {
    private String migrationId;
    private MigrationStatus currentStatus;
    private String migrationInstanceResourceId;
    private MigrationMode migrationMode;
    private MigrationOption migrationOption;
    private SourceType sourceType;
    private SslMode sslMode;
    private DbServerMetadata sourceDbServerMetadata;
    private DbServerMetadata targetDbServerMetadata;
    private String sourceDbServerResourceId;
    private String sourceDbServerFullyQualifiedDomainName;
    private String targetDbServerResourceId;
    private String targetDbServerFullyQualifiedDomainName;
    private MigrationSecretParameters secretParameters;
    private List<String> dbsToMigrate;
    private LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded;
    private OverwriteDbsInTargetEnum overwriteDbsInTarget;
    private OffsetDateTime migrationWindowStartTimeInUtc;
    private OffsetDateTime migrationWindowEndTimeInUtc;
    private MigrateRolesEnum migrateRoles;
    private StartDataMigrationEnum startDataMigration;
    private TriggerCutoverEnum triggerCutover;
    private List<String> dbsToTriggerCutoverOn;
    private CancelEnum cancel;
    private List<String> dbsToCancelMigrationOn;

    public String migrationId() {
        return this.migrationId;
    }

    public MigrationStatus currentStatus() {
        return this.currentStatus;
    }

    public String migrationInstanceResourceId() {
        return this.migrationInstanceResourceId;
    }

    public MigrationResourceProperties withMigrationInstanceResourceId(String migrationInstanceResourceId) {
        this.migrationInstanceResourceId = migrationInstanceResourceId;
        return this;
    }

    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    public MigrationResourceProperties withMigrationMode(MigrationMode migrationMode) {
        this.migrationMode = migrationMode;
        return this;
    }

    public MigrationOption migrationOption() {
        return this.migrationOption;
    }

    public MigrationResourceProperties withMigrationOption(MigrationOption migrationOption) {
        this.migrationOption = migrationOption;
        return this;
    }

    public SourceType sourceType() {
        return this.sourceType;
    }

    public MigrationResourceProperties withSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public SslMode sslMode() {
        return this.sslMode;
    }

    public MigrationResourceProperties withSslMode(SslMode sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public DbServerMetadata sourceDbServerMetadata() {
        return this.sourceDbServerMetadata;
    }

    public DbServerMetadata targetDbServerMetadata() {
        return this.targetDbServerMetadata;
    }

    public String sourceDbServerResourceId() {
        return this.sourceDbServerResourceId;
    }

    public MigrationResourceProperties withSourceDbServerResourceId(String sourceDbServerResourceId) {
        this.sourceDbServerResourceId = sourceDbServerResourceId;
        return this;
    }

    public String sourceDbServerFullyQualifiedDomainName() {
        return this.sourceDbServerFullyQualifiedDomainName;
    }

    public MigrationResourceProperties withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        this.sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName;
        return this;
    }

    public String targetDbServerResourceId() {
        return this.targetDbServerResourceId;
    }

    public String targetDbServerFullyQualifiedDomainName() {
        return this.targetDbServerFullyQualifiedDomainName;
    }

    public MigrationResourceProperties withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        this.targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName;
        return this;
    }

    public MigrationSecretParameters secretParameters() {
        return this.secretParameters;
    }

    public MigrationResourceProperties withSecretParameters(MigrationSecretParameters secretParameters) {
        this.secretParameters = secretParameters;
        return this;
    }

    public List<String> dbsToMigrate() {
        return this.dbsToMigrate;
    }

    public MigrationResourceProperties withDbsToMigrate(List<String> dbsToMigrate) {
        this.dbsToMigrate = dbsToMigrate;
        return this;
    }

    public LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.setupLogicalReplicationOnSourceDbIfNeeded;
    }

    public MigrationResourceProperties withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded;
        return this;
    }

    public OverwriteDbsInTargetEnum overwriteDbsInTarget() {
        return this.overwriteDbsInTarget;
    }

    public MigrationResourceProperties withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget) {
        this.overwriteDbsInTarget = overwriteDbsInTarget;
        return this;
    }

    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.migrationWindowStartTimeInUtc;
    }

    public MigrationResourceProperties withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        this.migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc;
        return this;
    }

    public OffsetDateTime migrationWindowEndTimeInUtc() {
        return this.migrationWindowEndTimeInUtc;
    }

    public MigrationResourceProperties withMigrationWindowEndTimeInUtc(OffsetDateTime migrationWindowEndTimeInUtc) {
        this.migrationWindowEndTimeInUtc = migrationWindowEndTimeInUtc;
        return this;
    }

    public MigrateRolesEnum migrateRoles() {
        return this.migrateRoles;
    }

    public MigrationResourceProperties withMigrateRoles(MigrateRolesEnum migrateRoles) {
        this.migrateRoles = migrateRoles;
        return this;
    }

    public StartDataMigrationEnum startDataMigration() {
        return this.startDataMigration;
    }

    public MigrationResourceProperties withStartDataMigration(StartDataMigrationEnum startDataMigration) {
        this.startDataMigration = startDataMigration;
        return this;
    }

    public TriggerCutoverEnum triggerCutover() {
        return this.triggerCutover;
    }

    public MigrationResourceProperties withTriggerCutover(TriggerCutoverEnum triggerCutover) {
        this.triggerCutover = triggerCutover;
        return this;
    }

    public List<String> dbsToTriggerCutoverOn() {
        return this.dbsToTriggerCutoverOn;
    }

    public MigrationResourceProperties withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        this.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
        return this;
    }

    public CancelEnum cancel() {
        return this.cancel;
    }

    public MigrationResourceProperties withCancel(CancelEnum cancel) {
        this.cancel = cancel;
        return this;
    }

    public List<String> dbsToCancelMigrationOn() {
        return this.dbsToCancelMigrationOn;
    }

    public MigrationResourceProperties withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        this.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
        return this;
    }

    public void validate() {
        if (this.currentStatus() != null) {
            this.currentStatus().validate();
        }
        if (this.sourceDbServerMetadata() != null) {
            this.sourceDbServerMetadata().validate();
        }
        if (this.targetDbServerMetadata() != null) {
            this.targetDbServerMetadata().validate();
        }
        if (this.secretParameters() != null) {
            this.secretParameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("migrationInstanceResourceId", this.migrationInstanceResourceId);
        jsonWriter.writeStringField("migrationMode", this.migrationMode == null ? null : this.migrationMode.toString());
        jsonWriter.writeStringField("migrationOption", this.migrationOption == null ? null : this.migrationOption.toString());
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        jsonWriter.writeStringField("sslMode", this.sslMode == null ? null : this.sslMode.toString());
        jsonWriter.writeStringField("sourceDbServerResourceId", this.sourceDbServerResourceId);
        jsonWriter.writeStringField("sourceDbServerFullyQualifiedDomainName", this.sourceDbServerFullyQualifiedDomainName);
        jsonWriter.writeStringField("targetDbServerFullyQualifiedDomainName", this.targetDbServerFullyQualifiedDomainName);
        jsonWriter.writeJsonField("secretParameters", (JsonSerializable)this.secretParameters);
        jsonWriter.writeArrayField("dbsToMigrate", this.dbsToMigrate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("setupLogicalReplicationOnSourceDbIfNeeded", this.setupLogicalReplicationOnSourceDbIfNeeded == null ? null : this.setupLogicalReplicationOnSourceDbIfNeeded.toString());
        jsonWriter.writeStringField("overwriteDbsInTarget", this.overwriteDbsInTarget == null ? null : this.overwriteDbsInTarget.toString());
        jsonWriter.writeStringField("migrationWindowStartTimeInUtc", this.migrationWindowStartTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowStartTimeInUtc));
        jsonWriter.writeStringField("migrationWindowEndTimeInUtc", this.migrationWindowEndTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowEndTimeInUtc));
        jsonWriter.writeStringField("migrateRoles", this.migrateRoles == null ? null : this.migrateRoles.toString());
        jsonWriter.writeStringField("startDataMigration", this.startDataMigration == null ? null : this.startDataMigration.toString());
        jsonWriter.writeStringField("triggerCutover", this.triggerCutover == null ? null : this.triggerCutover.toString());
        jsonWriter.writeArrayField("dbsToTriggerCutoverOn", this.dbsToTriggerCutoverOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cancel", this.cancel == null ? null : this.cancel.toString());
        jsonWriter.writeArrayField("dbsToCancelMigrationOn", this.dbsToCancelMigrationOn, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MigrationResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationResourceProperties)jsonReader.readObject(reader -> {
            MigrationResourceProperties deserializedMigrationResourceProperties = new MigrationResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationId = reader.getString();
                    continue;
                }
                if ("currentStatus".equals(fieldName)) {
                    deserializedMigrationResourceProperties.currentStatus = MigrationStatus.fromJson(reader);
                    continue;
                }
                if ("migrationInstanceResourceId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationInstanceResourceId = reader.getString();
                    continue;
                }
                if ("migrationMode".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationMode = MigrationMode.fromString(reader.getString());
                    continue;
                }
                if ("migrationOption".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationOption = MigrationOption.fromString(reader.getString());
                    continue;
                }
                if ("sourceType".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceType = SourceType.fromString(reader.getString());
                    continue;
                }
                if ("sslMode".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sslMode = SslMode.fromString(reader.getString());
                    continue;
                }
                if ("sourceDbServerMetadata".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceDbServerMetadata = DbServerMetadata.fromJson(reader);
                    continue;
                }
                if ("targetDbServerMetadata".equals(fieldName)) {
                    deserializedMigrationResourceProperties.targetDbServerMetadata = DbServerMetadata.fromJson(reader);
                    continue;
                }
                if ("sourceDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceDbServerResourceId = reader.getString();
                    continue;
                }
                if ("sourceDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("targetDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.targetDbServerResourceId = reader.getString();
                    continue;
                }
                if ("targetDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourceProperties.targetDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("secretParameters".equals(fieldName)) {
                    deserializedMigrationResourceProperties.secretParameters = MigrationSecretParameters.fromJson(reader);
                    continue;
                }
                if ("dbsToMigrate".equals(fieldName)) {
                    List dbsToMigrate;
                    deserializedMigrationResourceProperties.dbsToMigrate = dbsToMigrate = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("setupLogicalReplicationOnSourceDbIfNeeded".equals(fieldName)) {
                    deserializedMigrationResourceProperties.setupLogicalReplicationOnSourceDbIfNeeded = LogicalReplicationOnSourceDbEnum.fromString(reader.getString());
                    continue;
                }
                if ("overwriteDbsInTarget".equals(fieldName)) {
                    deserializedMigrationResourceProperties.overwriteDbsInTarget = OverwriteDbsInTargetEnum.fromString(reader.getString());
                    continue;
                }
                if ("migrationWindowStartTimeInUtc".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationWindowStartTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrationWindowEndTimeInUtc".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationWindowEndTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrateRoles".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrateRoles = MigrateRolesEnum.fromString(reader.getString());
                    continue;
                }
                if ("startDataMigration".equals(fieldName)) {
                    deserializedMigrationResourceProperties.startDataMigration = StartDataMigrationEnum.fromString(reader.getString());
                    continue;
                }
                if ("triggerCutover".equals(fieldName)) {
                    deserializedMigrationResourceProperties.triggerCutover = TriggerCutoverEnum.fromString(reader.getString());
                    continue;
                }
                if ("dbsToTriggerCutoverOn".equals(fieldName)) {
                    List dbsToTriggerCutoverOn;
                    deserializedMigrationResourceProperties.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cancel".equals(fieldName)) {
                    deserializedMigrationResourceProperties.cancel = CancelEnum.fromString(reader.getString());
                    continue;
                }
                if ("dbsToCancelMigrationOn".equals(fieldName)) {
                    List dbsToCancelMigrationOn;
                    deserializedMigrationResourceProperties.dbsToCancelMigrationOn = dbsToCancelMigrationOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationResourceProperties;
        });
    }
}

