/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ServerInner
extends Resource {
    private Sku sku;
    private UserAssignedIdentity identity;
    private ServerProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public ServerInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public UserAssignedIdentity identity() {
        return this.identity;
    }

    public ServerInner withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ServerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ServerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ServerInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerInner withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public String minorVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minorVersion();
    }

    public ServerState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    public ServerInner withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    public AuthConfig authConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().authConfig();
    }

    public ServerInner withAuthConfig(AuthConfig authConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAuthConfig(authConfig);
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    public ServerInner withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    public Backup backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    public ServerInner withBackup(Backup backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    public Network network() {
        return this.innerProperties() == null ? null : this.innerProperties().network();
    }

    public ServerInner withNetwork(Network network) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withNetwork(network);
        return this;
    }

    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    public ServerInner withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    public ServerInner withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    public String sourceServerResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceServerResourceId();
    }

    public ServerInner withSourceServerResourceId(String sourceServerResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withSourceServerResourceId(sourceServerResourceId);
        return this;
    }

    public OffsetDateTime pointInTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().pointInTimeUtc();
    }

    public ServerInner withPointInTimeUtc(OffsetDateTime pointInTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPointInTimeUtc(pointInTimeUtc);
        return this;
    }

    public String availabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZone();
    }

    public ServerInner withAvailabilityZone(String availabilityZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAvailabilityZone(availabilityZone);
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerInner withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public Integer replicaCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCapacity();
    }

    public Replica replica() {
        return this.innerProperties() == null ? null : this.innerProperties().replica();
    }

    public ServerInner withReplica(Replica replica) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplica(replica);
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ServerInner withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ServerInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerInner)((Object)jsonReader.readObject(reader -> {
            ServerInner deserializedServerInner = new ServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServerInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServerInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedServerInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedServerInner.identity = UserAssignedIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerInner.innerProperties = ServerProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedServerInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerInner;
        }));
    }
}

