/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CancelEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbServerMetadata;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceDbEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDbsInTargetEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SourceType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SslMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigrationEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutoverEnum;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class MigrationResourceImpl
implements MigrationResource,
MigrationResource.Definition,
MigrationResource.Update {
    private MigrationResourceInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String subscriptionId;
    private String resourceGroupName;
    private String targetDbServerName;
    private String migrationName;
    private MigrationResourceForPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String migrationId() {
        return this.innerModel().migrationId();
    }

    @Override
    public MigrationStatus currentStatus() {
        return this.innerModel().currentStatus();
    }

    @Override
    public String migrationInstanceResourceId() {
        return this.innerModel().migrationInstanceResourceId();
    }

    @Override
    public MigrationMode migrationMode() {
        return this.innerModel().migrationMode();
    }

    @Override
    public MigrationOption migrationOption() {
        return this.innerModel().migrationOption();
    }

    @Override
    public SourceType sourceType() {
        return this.innerModel().sourceType();
    }

    @Override
    public SslMode sslMode() {
        return this.innerModel().sslMode();
    }

    @Override
    public DbServerMetadata sourceDbServerMetadata() {
        return this.innerModel().sourceDbServerMetadata();
    }

    @Override
    public DbServerMetadata targetDbServerMetadata() {
        return this.innerModel().targetDbServerMetadata();
    }

    @Override
    public String sourceDbServerResourceId() {
        return this.innerModel().sourceDbServerResourceId();
    }

    @Override
    public String sourceDbServerFullyQualifiedDomainName() {
        return this.innerModel().sourceDbServerFullyQualifiedDomainName();
    }

    @Override
    public String targetDbServerResourceId() {
        return this.innerModel().targetDbServerResourceId();
    }

    @Override
    public String targetDbServerFullyQualifiedDomainName() {
        return this.innerModel().targetDbServerFullyQualifiedDomainName();
    }

    @Override
    public MigrationSecretParameters secretParameters() {
        return this.innerModel().secretParameters();
    }

    @Override
    public List<String> dbsToMigrate() {
        List<String> inner = this.innerModel().dbsToMigrate();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.innerModel().setupLogicalReplicationOnSourceDbIfNeeded();
    }

    @Override
    public OverwriteDbsInTargetEnum overwriteDbsInTarget() {
        return this.innerModel().overwriteDbsInTarget();
    }

    @Override
    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.innerModel().migrationWindowStartTimeInUtc();
    }

    @Override
    public OffsetDateTime migrationWindowEndTimeInUtc() {
        return this.innerModel().migrationWindowEndTimeInUtc();
    }

    @Override
    public MigrateRolesEnum migrateRoles() {
        return this.innerModel().migrateRoles();
    }

    @Override
    public StartDataMigrationEnum startDataMigration() {
        return this.innerModel().startDataMigration();
    }

    @Override
    public TriggerCutoverEnum triggerCutover() {
        return this.innerModel().triggerCutover();
    }

    @Override
    public List<String> dbsToTriggerCutoverOn() {
        List<String> inner = this.innerModel().dbsToTriggerCutoverOn();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public CancelEnum cancel() {
        return this.innerModel().cancel();
    }

    @Override
    public List<String> dbsToCancelMigrationOn() {
        List<String> inner = this.innerModel().dbsToCancelMigrationOn();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MigrationResourceInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public MigrationResourceImpl withExistingFlexibleServer(String subscriptionId, String resourceGroupName, String targetDbServerName) {
        this.subscriptionId = subscriptionId;
        this.resourceGroupName = resourceGroupName;
        this.targetDbServerName = targetDbServerName;
        return this;
    }

    @Override
    public MigrationResource create() {
        this.innerObject = (MigrationResourceInner)((Object)this.serviceManager.serviceClient().getMigrations().createWithResponse(this.subscriptionId, this.resourceGroupName, this.targetDbServerName, this.migrationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public MigrationResource create(Context context) {
        this.innerObject = (MigrationResourceInner)((Object)this.serviceManager.serviceClient().getMigrations().createWithResponse(this.subscriptionId, this.resourceGroupName, this.targetDbServerName, this.migrationName, this.innerModel(), context).getValue());
        return this;
    }

    MigrationResourceImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new MigrationResourceInner();
        this.serviceManager = serviceManager;
        this.migrationName = name;
    }

    @Override
    public MigrationResourceImpl update() {
        this.updateParameters = new MigrationResourceForPatch();
        return this;
    }

    @Override
    public MigrationResource apply() {
        this.innerObject = (MigrationResourceInner)((Object)this.serviceManager.serviceClient().getMigrations().updateWithResponse(this.subscriptionId, this.resourceGroupName, this.targetDbServerName, this.migrationName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public MigrationResource apply(Context context) {
        this.innerObject = (MigrationResourceInner)((Object)this.serviceManager.serviceClient().getMigrations().updateWithResponse(this.subscriptionId, this.resourceGroupName, this.targetDbServerName, this.migrationName, this.updateParameters, context).getValue());
        return this;
    }

    MigrationResourceImpl(MigrationResourceInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.subscriptionId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "subscriptions");
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.targetDbServerName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.migrationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "migrations");
    }

    @Override
    public MigrationResource refresh() {
        this.innerObject = (MigrationResourceInner)((Object)this.serviceManager.serviceClient().getMigrations().getWithResponse(this.subscriptionId, this.resourceGroupName, this.targetDbServerName, this.migrationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MigrationResource refresh(Context context) {
        this.innerObject = (MigrationResourceInner)((Object)this.serviceManager.serviceClient().getMigrations().getWithResponse(this.subscriptionId, this.resourceGroupName, this.targetDbServerName, this.migrationName, context).getValue());
        return this;
    }

    @Override
    public MigrationResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public MigrationResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public MigrationResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public MigrationResourceImpl withMigrationInstanceResourceId(String migrationInstanceResourceId) {
        this.innerModel().withMigrationInstanceResourceId(migrationInstanceResourceId);
        return this;
    }

    @Override
    public MigrationResourceImpl withMigrationMode(MigrationMode migrationMode) {
        if (this.isInCreateMode()) {
            this.innerModel().withMigrationMode(migrationMode);
            return this;
        }
        this.updateParameters.withMigrationMode(migrationMode);
        return this;
    }

    @Override
    public MigrationResourceImpl withMigrationOption(MigrationOption migrationOption) {
        this.innerModel().withMigrationOption(migrationOption);
        return this;
    }

    @Override
    public MigrationResourceImpl withSourceType(SourceType sourceType) {
        this.innerModel().withSourceType(sourceType);
        return this;
    }

    @Override
    public MigrationResourceImpl withSslMode(SslMode sslMode) {
        this.innerModel().withSslMode(sslMode);
        return this;
    }

    @Override
    public MigrationResourceImpl withSourceDbServerResourceId(String sourceDbServerResourceId) {
        if (this.isInCreateMode()) {
            this.innerModel().withSourceDbServerResourceId(sourceDbServerResourceId);
            return this;
        }
        this.updateParameters.withSourceDbServerResourceId(sourceDbServerResourceId);
        return this;
    }

    @Override
    public MigrationResourceImpl withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        if (this.isInCreateMode()) {
            this.innerModel().withSourceDbServerFullyQualifiedDomainName(sourceDbServerFullyQualifiedDomainName);
            return this;
        }
        this.updateParameters.withSourceDbServerFullyQualifiedDomainName(sourceDbServerFullyQualifiedDomainName);
        return this;
    }

    @Override
    public MigrationResourceImpl withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        if (this.isInCreateMode()) {
            this.innerModel().withTargetDbServerFullyQualifiedDomainName(targetDbServerFullyQualifiedDomainName);
            return this;
        }
        this.updateParameters.withTargetDbServerFullyQualifiedDomainName(targetDbServerFullyQualifiedDomainName);
        return this;
    }

    @Override
    public MigrationResourceImpl withSecretParameters(MigrationSecretParameters secretParameters) {
        if (this.isInCreateMode()) {
            this.innerModel().withSecretParameters(secretParameters);
            return this;
        }
        this.updateParameters.withSecretParameters(secretParameters);
        return this;
    }

    @Override
    public MigrationResourceImpl withDbsToMigrate(List<String> dbsToMigrate) {
        if (this.isInCreateMode()) {
            this.innerModel().withDbsToMigrate(dbsToMigrate);
            return this;
        }
        this.updateParameters.withDbsToMigrate(dbsToMigrate);
        return this;
    }

    @Override
    public MigrationResourceImpl withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded) {
        if (this.isInCreateMode()) {
            this.innerModel().withSetupLogicalReplicationOnSourceDbIfNeeded(setupLogicalReplicationOnSourceDbIfNeeded);
            return this;
        }
        this.updateParameters.withSetupLogicalReplicationOnSourceDbIfNeeded(setupLogicalReplicationOnSourceDbIfNeeded);
        return this;
    }

    @Override
    public MigrationResourceImpl withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget) {
        if (this.isInCreateMode()) {
            this.innerModel().withOverwriteDbsInTarget(overwriteDbsInTarget);
            return this;
        }
        this.updateParameters.withOverwriteDbsInTarget(overwriteDbsInTarget);
        return this;
    }

    @Override
    public MigrationResourceImpl withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        if (this.isInCreateMode()) {
            this.innerModel().withMigrationWindowStartTimeInUtc(migrationWindowStartTimeInUtc);
            return this;
        }
        this.updateParameters.withMigrationWindowStartTimeInUtc(migrationWindowStartTimeInUtc);
        return this;
    }

    @Override
    public MigrationResourceImpl withMigrationWindowEndTimeInUtc(OffsetDateTime migrationWindowEndTimeInUtc) {
        this.innerModel().withMigrationWindowEndTimeInUtc(migrationWindowEndTimeInUtc);
        return this;
    }

    @Override
    public MigrationResourceImpl withMigrateRoles(MigrateRolesEnum migrateRoles) {
        if (this.isInCreateMode()) {
            this.innerModel().withMigrateRoles(migrateRoles);
            return this;
        }
        this.updateParameters.withMigrateRoles(migrateRoles);
        return this;
    }

    @Override
    public MigrationResourceImpl withStartDataMigration(StartDataMigrationEnum startDataMigration) {
        if (this.isInCreateMode()) {
            this.innerModel().withStartDataMigration(startDataMigration);
            return this;
        }
        this.updateParameters.withStartDataMigration(startDataMigration);
        return this;
    }

    @Override
    public MigrationResourceImpl withTriggerCutover(TriggerCutoverEnum triggerCutover) {
        if (this.isInCreateMode()) {
            this.innerModel().withTriggerCutover(triggerCutover);
            return this;
        }
        this.updateParameters.withTriggerCutover(triggerCutover);
        return this;
    }

    @Override
    public MigrationResourceImpl withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        if (this.isInCreateMode()) {
            this.innerModel().withDbsToTriggerCutoverOn(dbsToTriggerCutoverOn);
            return this;
        }
        this.updateParameters.withDbsToTriggerCutoverOn(dbsToTriggerCutoverOn);
        return this;
    }

    @Override
    public MigrationResourceImpl withCancel(CancelEnum cancel) {
        if (this.isInCreateMode()) {
            this.innerModel().withCancel(cancel);
            return this;
        }
        this.updateParameters.withCancel(cancel);
        return this;
    }

    @Override
    public MigrationResourceImpl withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        if (this.isInCreateMode()) {
            this.innerModel().withDbsToCancelMigrationOn(dbsToCancelMigrationOn);
            return this;
        }
        this.updateParameters.withDbsToCancelMigrationOn(dbsToCancelMigrationOn);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

