/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerThreatProtectionSettingsModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServerThreatProtectionSettingsModelImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettings;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettingsModel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionName;

public final class ServerThreatProtectionSettingsImpl
implements ServerThreatProtectionSettings {
    private static final ClientLogger LOGGER = new ClientLogger(ServerThreatProtectionSettingsImpl.class);
    private final ServerThreatProtectionSettingsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ServerThreatProtectionSettingsImpl(ServerThreatProtectionSettingsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ServerThreatProtectionSettingsModel> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerThreatProtectionSettingsModelInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerThreatProtectionSettingsModelImpl((ServerThreatProtectionSettingsModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerThreatProtectionSettingsModel> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerThreatProtectionSettingsModelInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerThreatProtectionSettingsModelImpl((ServerThreatProtectionSettingsModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ServerThreatProtectionSettingsModel> getWithResponse(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, Context context) {
        Response<ServerThreatProtectionSettingsModelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, threatProtectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerThreatProtectionSettingsModelImpl((ServerThreatProtectionSettingsModelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServerThreatProtectionSettingsModel get(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName) {
        ServerThreatProtectionSettingsModelInner inner = this.serviceClient().get(resourceGroupName, serverName, threatProtectionName);
        if (inner != null) {
            return new ServerThreatProtectionSettingsModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ServerThreatProtectionSettingsModel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String threatProtectionNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "advancedThreatProtectionSettings");
        if (threatProtectionNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'advancedThreatProtectionSettings'.", id)));
        }
        ThreatProtectionName threatProtectionName = ThreatProtectionName.fromString(threatProtectionNameLocal);
        return (ServerThreatProtectionSettingsModel)this.getWithResponse(resourceGroupName, serverName, threatProtectionName, Context.NONE).getValue();
    }

    @Override
    public Response<ServerThreatProtectionSettingsModel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String threatProtectionNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "advancedThreatProtectionSettings");
        if (threatProtectionNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'advancedThreatProtectionSettings'.", id)));
        }
        ThreatProtectionName threatProtectionName = ThreatProtectionName.fromString(threatProtectionNameLocal);
        return this.getWithResponse(resourceGroupName, serverName, threatProtectionName, context);
    }

    private ServerThreatProtectionSettingsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerThreatProtectionSettingsModelImpl define(ThreatProtectionName name) {
        return new ServerThreatProtectionSettingsModelImpl(name, this.manager());
    }
}

