/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ActiveDirectoryAuthEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PasswordAuthEnum;
import java.io.IOException;

public final class AuthConfig
implements JsonSerializable<AuthConfig> {
    private ActiveDirectoryAuthEnum activeDirectoryAuth;
    private PasswordAuthEnum passwordAuth;
    private String tenantId;

    public ActiveDirectoryAuthEnum activeDirectoryAuth() {
        return this.activeDirectoryAuth;
    }

    public AuthConfig withActiveDirectoryAuth(ActiveDirectoryAuthEnum activeDirectoryAuth) {
        this.activeDirectoryAuth = activeDirectoryAuth;
        return this;
    }

    public PasswordAuthEnum passwordAuth() {
        return this.passwordAuth;
    }

    public AuthConfig withPasswordAuth(PasswordAuthEnum passwordAuth) {
        this.passwordAuth = passwordAuth;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public AuthConfig withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("activeDirectoryAuth", this.activeDirectoryAuth == null ? null : this.activeDirectoryAuth.toString());
        jsonWriter.writeStringField("passwordAuth", this.passwordAuth == null ? null : this.passwordAuth.toString());
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    public static AuthConfig fromJson(JsonReader jsonReader) throws IOException {
        return (AuthConfig)jsonReader.readObject(reader -> {
            AuthConfig deserializedAuthConfig = new AuthConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("activeDirectoryAuth".equals(fieldName)) {
                    deserializedAuthConfig.activeDirectoryAuth = ActiveDirectoryAuthEnum.fromString(reader.getString());
                    continue;
                }
                if ("passwordAuth".equals(fieldName)) {
                    deserializedAuthConfig.passwordAuth = PasswordAuthEnum.fromString(reader.getString());
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedAuthConfig.tenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthConfig;
        });
    }
}

