/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbMigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSubState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationDetails;
import java.io.IOException;
import java.util.Map;

public final class MigrationSubStateDetails
implements JsonSerializable<MigrationSubStateDetails> {
    private MigrationSubState currentSubState;
    private Map<String, DbMigrationStatus> dbDetails;
    private ValidationDetails validationDetails;

    public MigrationSubState currentSubState() {
        return this.currentSubState;
    }

    public Map<String, DbMigrationStatus> dbDetails() {
        return this.dbDetails;
    }

    public MigrationSubStateDetails withDbDetails(Map<String, DbMigrationStatus> dbDetails) {
        this.dbDetails = dbDetails;
        return this;
    }

    public ValidationDetails validationDetails() {
        return this.validationDetails;
    }

    public MigrationSubStateDetails withValidationDetails(ValidationDetails validationDetails) {
        this.validationDetails = validationDetails;
        return this;
    }

    public void validate() {
        if (this.dbDetails() != null) {
            this.dbDetails().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.validationDetails() != null) {
            this.validationDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("dbDetails", this.dbDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("validationDetails", (JsonSerializable)this.validationDetails);
        return jsonWriter.writeEndObject();
    }

    public static MigrationSubStateDetails fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationSubStateDetails)jsonReader.readObject(reader -> {
            MigrationSubStateDetails deserializedMigrationSubStateDetails = new MigrationSubStateDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentSubState".equals(fieldName)) {
                    deserializedMigrationSubStateDetails.currentSubState = MigrationSubState.fromString(reader.getString());
                    continue;
                }
                if ("dbDetails".equals(fieldName)) {
                    Map dbDetails;
                    deserializedMigrationSubStateDetails.dbDetails = dbDetails = reader.readMap(reader1 -> DbMigrationStatus.fromJson(reader1));
                    continue;
                }
                if ("validationDetails".equals(fieldName)) {
                    deserializedMigrationSubStateDetails.validationDetails = ValidationDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationSubStateDetails;
        });
    }
}

