/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AdvancedThreatProtectionSettingsProperties
implements JsonSerializable<AdvancedThreatProtectionSettingsProperties> {
    private ThreatProtectionState state;
    private OffsetDateTime creationTime;
    private static final ClientLogger LOGGER = new ClientLogger(AdvancedThreatProtectionSettingsProperties.class);

    public ThreatProtectionState state() {
        return this.state;
    }

    public AdvancedThreatProtectionSettingsProperties withState(ThreatProtectionState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model AdvancedThreatProtectionSettingsProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static AdvancedThreatProtectionSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AdvancedThreatProtectionSettingsProperties)jsonReader.readObject(reader -> {
            AdvancedThreatProtectionSettingsProperties deserializedAdvancedThreatProtectionSettingsProperties = new AdvancedThreatProtectionSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedAdvancedThreatProtectionSettingsProperties.state = ThreatProtectionState.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedAdvancedThreatProtectionSettingsProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdvancedThreatProtectionSettingsProperties;
        });
    }
}

