/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FastProvisioningEditionCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FastProvisioningSupport;
import com.azure.resourcemanager.postgresqlflexibleserver.models.GeographicallyRedundantBackupSupport;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LocationRestricted;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OnlineStorageResizeSupport;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerEditionCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersionCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StorageAutoGrowthSupport;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SupportedFeature;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ZoneRedundantHighAvailabilitySupport;
import java.io.IOException;
import java.util.List;

public final class CapabilityInner
extends CapabilityBase {
    private String name;
    private List<ServerEditionCapability> supportedServerEditions;
    private List<ServerVersionCapability> supportedServerVersions;
    private List<SupportedFeature> supportedFeatures;
    private FastProvisioningSupport fastProvisioningSupported;
    private List<FastProvisioningEditionCapability> supportedFastProvisioningEditions;
    private GeographicallyRedundantBackupSupport geoBackupSupported;
    private ZoneRedundantHighAvailabilitySupport zoneRedundantHaSupported;
    private ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport zoneRedundantHaAndGeoBackupSupported;
    private StorageAutoGrowthSupport storageAutoGrowthSupported;
    private OnlineStorageResizeSupport onlineResizeSupported;
    private LocationRestricted restricted;
    private String reason;
    private CapabilityStatus status;

    public String name() {
        return this.name;
    }

    public CapabilityInner withName(String name) {
        this.name = name;
        return this;
    }

    public List<ServerEditionCapability> supportedServerEditions() {
        return this.supportedServerEditions;
    }

    public List<ServerVersionCapability> supportedServerVersions() {
        return this.supportedServerVersions;
    }

    public List<SupportedFeature> supportedFeatures() {
        return this.supportedFeatures;
    }

    public FastProvisioningSupport fastProvisioningSupported() {
        return this.fastProvisioningSupported;
    }

    public List<FastProvisioningEditionCapability> supportedFastProvisioningEditions() {
        return this.supportedFastProvisioningEditions;
    }

    public GeographicallyRedundantBackupSupport geoBackupSupported() {
        return this.geoBackupSupported;
    }

    public ZoneRedundantHighAvailabilitySupport zoneRedundantHaSupported() {
        return this.zoneRedundantHaSupported;
    }

    public ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport zoneRedundantHaAndGeoBackupSupported() {
        return this.zoneRedundantHaAndGeoBackupSupported;
    }

    public StorageAutoGrowthSupport storageAutoGrowthSupported() {
        return this.storageAutoGrowthSupported;
    }

    public OnlineStorageResizeSupport onlineResizeSupported() {
        return this.onlineResizeSupported;
    }

    public LocationRestricted restricted() {
        return this.restricted;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.supportedServerEditions() != null) {
            this.supportedServerEditions().forEach(e -> e.validate());
        }
        if (this.supportedServerVersions() != null) {
            this.supportedServerVersions().forEach(e -> e.validate());
        }
        if (this.supportedFeatures() != null) {
            this.supportedFeatures().forEach(e -> e.validate());
        }
        if (this.supportedFastProvisioningEditions() != null) {
            this.supportedFastProvisioningEditions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static CapabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return (CapabilityInner)jsonReader.readObject(reader -> {
            CapabilityInner deserializedCapabilityInner = new CapabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedCapabilityInner.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedCapabilityInner.reason = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCapabilityInner.name = reader.getString();
                    continue;
                }
                if ("supportedServerEditions".equals(fieldName)) {
                    List supportedServerEditions;
                    deserializedCapabilityInner.supportedServerEditions = supportedServerEditions = reader.readArray(reader1 -> ServerEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedServerVersions".equals(fieldName)) {
                    List supportedServerVersions;
                    deserializedCapabilityInner.supportedServerVersions = supportedServerVersions = reader.readArray(reader1 -> ServerVersionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedFeatures".equals(fieldName)) {
                    List supportedFeatures;
                    deserializedCapabilityInner.supportedFeatures = supportedFeatures = reader.readArray(reader1 -> SupportedFeature.fromJson(reader1));
                    continue;
                }
                if ("fastProvisioningSupported".equals(fieldName)) {
                    deserializedCapabilityInner.fastProvisioningSupported = FastProvisioningSupport.fromString(reader.getString());
                    continue;
                }
                if ("supportedFastProvisioningEditions".equals(fieldName)) {
                    List supportedFastProvisioningEditions;
                    deserializedCapabilityInner.supportedFastProvisioningEditions = supportedFastProvisioningEditions = reader.readArray(reader1 -> FastProvisioningEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("geoBackupSupported".equals(fieldName)) {
                    deserializedCapabilityInner.geoBackupSupported = GeographicallyRedundantBackupSupport.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundantHaSupported".equals(fieldName)) {
                    deserializedCapabilityInner.zoneRedundantHaSupported = ZoneRedundantHighAvailabilitySupport.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundantHaAndGeoBackupSupported".equals(fieldName)) {
                    deserializedCapabilityInner.zoneRedundantHaAndGeoBackupSupported = ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport.fromString(reader.getString());
                    continue;
                }
                if ("storageAutoGrowthSupported".equals(fieldName)) {
                    deserializedCapabilityInner.storageAutoGrowthSupported = StorageAutoGrowthSupport.fromString(reader.getString());
                    continue;
                }
                if ("onlineResizeSupported".equals(fieldName)) {
                    deserializedCapabilityInner.onlineResizeSupported = OnlineStorageResizeSupport.fromString(reader.getString());
                    continue;
                }
                if ("restricted".equals(fieldName)) {
                    deserializedCapabilityInner.restricted = LocationRestricted.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapabilityInner;
        });
    }
}

