/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.QuotaUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.QuotaUsageInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.QuotaUsageImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.QuotaUsage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.QuotaUsages;

public final class QuotaUsagesImpl
implements QuotaUsages {
    private static final ClientLogger LOGGER = new ClientLogger(QuotaUsagesImpl.class);
    private final QuotaUsagesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public QuotaUsagesImpl(QuotaUsagesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<QuotaUsage> list(String locationName) {
        PagedIterable<QuotaUsageInner> inner = this.serviceClient().list(locationName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new QuotaUsageImpl((QuotaUsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<QuotaUsage> list(String locationName, Context context) {
        PagedIterable<QuotaUsageInner> inner = this.serviceClient().list(locationName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new QuotaUsageImpl((QuotaUsageInner)inner1, this.manager()));
    }

    private QuotaUsagesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

