/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.azure.resourcemanager.privatedns.fluent.models.VirtualNetworkLinkInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.azure.resourcemanager.privatedns.models.ProvisioningState;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLink;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLinkState;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

class VirtualNetworkLinkImpl
extends ExternalChildResourceImpl<VirtualNetworkLink, VirtualNetworkLinkInner, PrivateDnsZoneImpl, PrivateDnsZone>
implements VirtualNetworkLink,
VirtualNetworkLink.Definition<PrivateDnsZone.DefinitionStages.WithCreate>,
VirtualNetworkLink.UpdateDefinition<PrivateDnsZone.Update>,
VirtualNetworkLink.Update {
    private final ETagState etagState = new ETagState();
    private VirtualNetworkLinkInner linkToRemove = new VirtualNetworkLinkInner();

    VirtualNetworkLinkImpl(String name, PrivateDnsZoneImpl parent, VirtualNetworkLinkInner innerModel) {
        super(name, (Object)parent, (Object)innerModel);
        this.linkToRemove.withTags(new HashMap());
    }

    static VirtualNetworkLinkImpl newVirtualNetworkLink(String name, PrivateDnsZoneImpl parent) {
        VirtualNetworkLinkInner inner = new VirtualNetworkLinkInner();
        inner.withLocation("global");
        return new VirtualNetworkLinkImpl(name, parent, inner);
    }

    @Override
    public String etag() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).etag();
    }

    @Override
    public String referencedVirtualNetworkId() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).virtualNetwork() == null ? null : ((VirtualNetworkLinkInner)((Object)this.innerModel())).virtualNetwork().id();
    }

    @Override
    public boolean isAutoRegistrationEnabled() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).registrationEnabled();
    }

    @Override
    public VirtualNetworkLinkState virtualNetworkLinkState() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).virtualNetworkLinkState();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public VirtualNetworkLinkImpl enableAutoRegistration() {
        ((VirtualNetworkLinkInner)((Object)this.innerModel())).withRegistrationEnabled(true);
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl disableAutoRegistration() {
        ((VirtualNetworkLinkInner)((Object)this.innerModel())).withRegistrationEnabled(false);
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl withETagCheck() {
        this.etagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl withETagCheck(String etagValue) {
        this.etagState.withExplicitETagCheckOnUpdate(etagValue);
        return this;
    }

    public VirtualNetworkLinkImpl withVirtualNetworkId(String virtualNetworkId) {
        ((VirtualNetworkLinkInner)((Object)this.innerModel())).withVirtualNetwork(new SubResource().withId(virtualNetworkId));
        return this;
    }

    public VirtualNetworkLinkImpl withRegion(String regionName) {
        ((VirtualNetworkLinkInner)((Object)this.innerModel())).withLocation(regionName);
        return this;
    }

    public VirtualNetworkLinkImpl withRegion(Region region) {
        return this.withRegion(region.name());
    }

    public VirtualNetworkLinkImpl withTags(Map<String, String> tags) {
        ((VirtualNetworkLinkInner)((Object)this.innerModel())).withTags(tags);
        return this;
    }

    public VirtualNetworkLinkImpl withTag(String key, String value) {
        if (((VirtualNetworkLinkInner)((Object)this.innerModel())).tags() == null) {
            ((VirtualNetworkLinkInner)((Object)this.innerModel())).withTags(new HashMap());
        }
        ((VirtualNetworkLinkInner)((Object)this.innerModel())).tags().put(key, value);
        return this;
    }

    public VirtualNetworkLinkImpl withoutTag(String key) {
        this.linkToRemove.tags().put(key, null);
        return this;
    }

    public Mono<VirtualNetworkLink> createResourceAsync() {
        return this.createOrUpdateAsync((VirtualNetworkLinkInner)((Object)this.innerModel()));
    }

    public Mono<VirtualNetworkLink> updateResourceAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getVirtualNetworkLinks().getAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.name()).map(virtualNetworkLinkInner -> this.prepareForUpdate((VirtualNetworkLinkInner)((Object)virtualNetworkLinkInner))).flatMap(virtualNetworkLinkInner -> this.createOrUpdateAsync((VirtualNetworkLinkInner)((Object)virtualNetworkLinkInner)));
    }

    public Mono<Void> deleteResourceAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getVirtualNetworkLinks().deleteAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.name(), this.etagState.ifMatchValueOnDelete());
    }

    protected Mono<VirtualNetworkLinkInner> getInnerAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getVirtualNetworkLinks().getAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.name());
    }

    public String id() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).id();
    }

    public PrivateDnsZoneImpl attach() {
        return (PrivateDnsZoneImpl)this.parent();
    }

    private Mono<VirtualNetworkLink> createOrUpdateAsync(VirtualNetworkLinkInner resource) {
        VirtualNetworkLinkImpl self = this;
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)((PrivateDnsZoneImpl)this.parent()).manager()).serviceClient()).getVirtualNetworkLinks().createOrUpdateAsync(((PrivateDnsZoneImpl)this.parent()).resourceGroupName(), ((PrivateDnsZoneImpl)this.parent()).name(), this.name(), resource, this.etagState.ifMatchValueOnUpdate(resource.etag()), this.etagState.ifNonMatchValueOnCreate()).map(virtualNetworkLinkInner -> {
            this.setInner(virtualNetworkLinkInner);
            self.etagState.clear();
            return self;
        });
    }

    private VirtualNetworkLinkInner prepareForUpdate(VirtualNetworkLinkInner resource) {
        if (((VirtualNetworkLinkInner)((Object)this.innerModel())).registrationEnabled() != null) {
            resource.withRegistrationEnabled(((VirtualNetworkLinkInner)((Object)this.innerModel())).registrationEnabled());
        }
        if (((VirtualNetworkLinkInner)((Object)this.innerModel())).tags() != null && !((VirtualNetworkLinkInner)((Object)this.innerModel())).tags().isEmpty()) {
            if (resource.tags() == null) {
                resource.withTags(new HashMap());
            }
            for (Map.Entry entryToAdd : ((VirtualNetworkLinkInner)((Object)this.innerModel())).tags().entrySet()) {
                resource.tags().put((String)entryToAdd.getKey(), (String)entryToAdd.getValue());
            }
            ((VirtualNetworkLinkInner)((Object)this.innerModel())).tags().clear();
        }
        if (!this.linkToRemove.tags().isEmpty()) {
            for (Map.Entry entryToDelete : this.linkToRemove.tags().entrySet()) {
                resource.tags().remove(entryToDelete.getKey());
            }
            this.linkToRemove.tags().clear();
        }
        return resource;
    }

    VirtualNetworkLinkImpl withETagOnDelete(String etagValue) {
        this.etagState.withExplicitETagCheckOnDelete(etagValue);
        return this;
    }

    private boolean isInCreateMode() {
        return ((VirtualNetworkLinkInner)((Object)this.innerModel())).id() == null;
    }
}

